% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/meta_rep.R
\name{replicate.gen}
\alias{replicate.gen}
\title{Compares effect sizes in the original and follow-up studies}
\usage{
replicate.gen(alpha, est1, se1, est2, se2)
}
\arguments{
\item{alpha}{alpha level for 1-alpha confidence}

\item{est1}{sample effect size in original study}

\item{se1}{effect size standard error in original study}

\item{est2}{sample effect size in follow-up study}

\item{se2}{effect size standard error in follow-up study}
}
\value{
A 4-row matrix. The rows are:
\itemize{
\item Row 1 summarizes the Original study
\item Row 2 summarizes the Follow-up study
\item Row 3 estimates the difference between studies
\item Row 4 estimates the average effect size between the two studies
}

Columns are:
\itemize{
\item Estimate - effect size estimate
\item SE - standard error
\item z - z-value
\item p - p-value
\item LL - lower limit of the confidence interval
\item UL - upper limit of the confidence interval
}
}
\description{
This function can be used to compare and combine any effect size (e.g.,odds
ratio, proportion ratio, proportion difference, slope coefficient, etc.)
using the effect size estimate and its standard error from the original study
and the follow-up study. The same results can be obtained using the
\link[vcmeta]{meta.lc.gen} function with appropriate contrast coefficients.
The confidence level for the difference is 1 – 2alpha.
}
\examples{
replicate.gen(.05, .782, .210, .650, .154)

# Should return: 
#                      Estimate        SE         z            p         LL        UL
#  Original:              0.782 0.2100000 3.7238095 1.962390e-04  0.3704076 1.1935924
#  Follow-up:             0.650 0.1540000 4.2207792 2.434593e-05  0.3481655 0.9518345
#  Original - Follow-up:  0.132 0.2604151 0.5068831 6.122368e-01 -0.2963446 0.5603446
#  Average:               0.716 0.1302075 5.4989141 3.821373e-08  0.4607979 0.9712021

}
\references{
\insertRef{Bonett2021}{vcmeta}
}
