% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/meta_model.R
\name{meta.lm.mean.ps}
\alias{meta.lm.mean.ps}
\title{Meta-regression analysis for paired-samples mean differences}
\usage{
meta.lm.mean.ps(alpha, m1, m2, sd1, sd2, cor, n, X)
}
\arguments{
\item{alpha}{alpha level for 1-alpha confidence}

\item{m1}{vector of sample means for group 1}

\item{m2}{vector of sample means for group 2}

\item{sd1}{vector of sample SDs for group 1}

\item{sd2}{vector of sample SDs for group 2}

\item{cor}{vector of correlations}

\item{n}{vector of sample sizes}

\item{X}{matrix of predictor values}
}
\value{
Returns a matrix.  The first row is for the intercept with one additional
row per predictor.  The matrix has the following columns:
\itemize{
\item Estimate - OLS estimate
\item SE - standard error
\item t - t-value
\item p - p-value
\item LL - lower limit of the confidence interval
\item UL - upper limit of the confidence interval
\item df - degrees of freedom
}
}
\description{
This function estimates the intercept and slope coefficients in a
meta-regression model where the dependent variable is a paired-samples
mean difference. The estimates are OLS estimates with standard
errors that accommodate residual heteroscedasticity.
}
\examples{
n <- c(65, 30, 29, 45, 50)
cor <- c(.87, .92, .85, .90, .88)
m1 <- c(20.1, 20.5, 19.3, 21.5, 19.4)
m2 <- c(10.4, 10.2, 8.5, 10.3, 7.8)
sd1 <- c(9.3, 9.9, 10.1, 10.5, 9.8)
sd2 <- c(7.8, 8.0, 8.4, 8.1, 8.7)
x1 <- c(2, 3, 3, 4, 4)
X <- matrix(x1, 5, 1)
meta.lm.mean.ps(.05, m1, m2, sd1, sd2, cor, n, X)

# Should return:
#    Estimate        SE        t     p        LL        UL  df
# b0     8.00 1.2491990 6.404104 0.000 5.5378833 10.462117 217
# b1     0.85 0.3796019 2.239188 0.026 0.1018213  1.598179 217


}
\references{
\insertRef{Bonett2009a}{vcmeta}
}
