% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/eq5d.R
\name{value_5L_Ind}
\alias{value_5L_Ind}
\title{Function to value EQ-5D-5L scores for various countries}
\usage{
value_5L_Ind(
  country,
  dimen,
  dimen2 = NA,
  dimen3 = NA,
  dimen4 = NA,
  dimen5 = NA
)
}
\arguments{
\item{country}{a country name from the list Canada,China,England,
Germany,HongKong,Indonesia,Ireland,Japan,Korea,Malaysia,Netherlands,
Poland,Spain,Taiwan,Thailand,and Uruguay}

\item{dimen}{a must input,response for EQ-5D-5L mobility  or the 5 digit 
response, or the vector of responses, e.g. 11111, c(1,1,1,1,1) or 1}

\item{dimen2}{response for EQ-5D-5L self care, or NA if the responses are 
given as dimen}

\item{dimen3}{response for EQ-5D-5L usual activities,or NA if the responses 
are given as dimen}

\item{dimen4}{response for EQ-5D-5L pain/discomfort, or NA if the responses 
are given as dimen}

\item{dimen5}{response for EQ-5D-5L anxiety/depression, or NA if the 
responses are given as dimen}
}
\value{
index values  if success, negative values if failure
}
\description{
Function to value EQ-5D-5L scores for various countries
}
\examples{
value_5L_Ind("England", 23434)
value_5L_Ind("China", 2, 3, 4, 3, 4)
value_5L_Ind("Poland", c(1, 2, 3, 4, 3))
}
