% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bed_map.r
\name{bed_map}
\alias{bed_map}
\alias{concat}
\alias{values_unique}
\alias{values}
\title{Calculate summaries from overlapping intervals.}
\usage{
bed_map(x, y, ..., min_overlap = 1)

concat(.data, sep = ",")

values_unique(.data, sep = ",")

values(.data, sep = ",")
}
\arguments{
\item{x}{\link{ivl_df}}

\item{y}{\link{ivl_df}}

\item{...}{name-value pairs specifying column names and expressions to apply}

\item{min_overlap}{minimum overlap for intervals.}

\item{.data}{data}

\item{sep}{separator character}
}
\value{
\link{ivl_df}
}
\description{
Apply functions like \code{\link[=min]{min()}} and \code{\link[=max]{max()}} to intersecting intervals.
\code{\link[=bed_map]{bed_map()}} uses \code{\link[=bed_intersect]{bed_intersect()}} to identify intersecting intervals, so
output columns will be suffixed with \code{.x} and \code{.y}. Expressions that refer to
input columns from \code{x} and \code{y} columns must take these suffixes into account.
}
\details{
Book-ended intervals can be included by setting \code{min_overlap = 0}.

Non-intersecting intervals from \code{x} are included in the result with \code{NA}
values.

input tbls are grouped by \code{chrom} by default, and additional
groups can be added using \code{\link[dplyr:group_by]{dplyr::group_by()}}. For example,
grouping by \code{strand} will constrain analyses to the same strand. To
compare opposing strands across two tbls, strands on the \code{y} tbl can
first be inverted using \code{\link[=flip_strands]{flip_strands()}}.
}
\examples{
x <- tibble::tribble(
 ~chrom, ~start, ~end,
 'chr1', 100,    250,
 'chr2', 250,    500
)

y <- tibble::tribble(
 ~chrom, ~start, ~end, ~value,
 'chr1', 100,    250,  10,
 'chr1', 150,    250,  20,
 'chr2', 250,    500,  500
)

bed_glyph(bed_map(x, y, value = sum(value)), label = 'value')

# summary examples
bed_map(x, y, .sum = sum(value))

bed_map(x, y, .min = min(value), .max = max(value))

# identify non-intersecting intervals to include in the result
res <- bed_map(x, y, .sum = sum(value))
x_not <- bed_intersect(x, y, invert = TRUE)
dplyr::bind_rows(res, x_not)

# create a list-column
bed_map(x, y, .values = list(value))

# use `nth` family from dplyr
bed_map(x, y, .first = dplyr::first(value))

bed_map(x, y, .absmax = abs(max(value)))

bed_map(x, y, .count = length(value))

bed_map(x, y, .vals = values(value))

# count defaults are NA not 0; differs from bedtools2 ...
bed_map(x, y, .counts = dplyr::n())

# ... but NA counts can be coverted to 0's
dplyr::mutate(bed_map(x, y, .counts = dplyr::n()), .counts = ifelse(is.na(.counts), 0, .counts))

}
\seealso{
\url{https://bedtools.readthedocs.io/en/latest/content/tools/map.html}

Other multiple set operations: 
\code{\link{bed_closest}()},
\code{\link{bed_coverage}()},
\code{\link{bed_intersect}()},
\code{\link{bed_subtract}()},
\code{\link{bed_window}()}
}
\concept{multiple set operations}
