% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/spacing.r
\name{interval_spacing}
\alias{interval_spacing}
\title{Calculate interval spacing.}
\usage{
interval_spacing(x)
}
\arguments{
\item{x}{\code{\link[=tbl_interval]{tbl_interval()}}}
}
\value{
\code{\link[=tbl_interval]{tbl_interval()}} with \code{.spacing} column.
}
\description{
Spacing for the first interval of each chromosome is undefined (\code{NA}). The
leading interval of an overlapping interval pair has a negative value.
}
\examples{
x <- trbl_interval(
  ~chrom, ~start, ~end,
  'chr1', 1,      100,
  'chr1', 150,    200,
  'chr2', 200,    300
)

interval_spacing(x)

}
\seealso{
Other utilities: \code{\link{bed12_to_exons}},
  \code{\link{bed_makewindows}},
  \code{\link{bound_intervals}}, \code{\link{flip_strands}}
}
