% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/read_bed.r
\name{read_bed}
\alias{read_bed}
\alias{read_bed12}
\alias{read_bedgraph}
\alias{read_narrowpeak}
\alias{read_broadpeak}
\title{Read BED and related files.}
\usage{
read_bed(filename, n_fields = 3, col_types = bed12_coltypes, sort = TRUE,
  ...)

read_bed12(filename, ...)

read_bedgraph(filename, ...)

read_narrowpeak(filename, ...)

read_broadpeak(filename, ...)
}
\arguments{
\item{filename}{file or URL}

\item{n_fields}{number fields in the BED file}

\item{col_types}{column type spec for \code{\link[readr:read_tsv]{readr::read_tsv()}}}

\item{sort}{sort the tbl by chrom and start}

\item{...}{options to pass to \code{\link[readr:read_tsv]{readr::read_tsv()}}}
}
\value{
\code{\link[=tbl_interval]{tbl_interval()}}
}
\description{
read functions for BED and related formats. Filenames can be
local file or URLs. The read functions load data into tbls with consistent
\code{chrom}, \code{start} and \code{end} colnames.
}
\details{
\url{https://genome.ucsc.edu/FAQ/FAQformat.html#format1}

\url{https://genome.ucsc.edu/FAQ/FAQformat.html#format1}

\url{https://genome.ucsc.edu/goldenPath/help/bedgraph.html}

\url{https://genome.ucsc.edu/FAQ/FAQformat.html#format12}

\url{https://genome.ucsc.edu/FAQ/FAQformat.html#format13}
}
\examples{
# read_bed assumes 3 field BED format.
read_bed(valr_example('3fields.bed.gz'))

read_bed(valr_example('6fields.bed.gz'), n_fields = 6)

# result is sorted by chrom and start unless `sort = FALSE`
read_bed(valr_example('3fields.bed.gz'), sort = FALSE)


read_bed12(valr_example('mm9.bed12.gz'))


read_bedgraph(valr_example('test.bg.gz'))


read_narrowpeak(valr_example('sample.narrowPeak.gz'))


read_broadpeak(valr_example('sample.broadPeak.gz'))

}
\seealso{
Other read functions: \code{\link{read_genome}},
  \code{\link{read_vcf}}
}
