% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/checkers.R
\name{misc-checkers}
\alias{misc-checkers}
\title{Miscellaneous checkers}
\arguments{
\item{\dots}{Check items, i.e., formulae that are one-sided or have a string
as left-hand side (see \emph{Check Formulae of Local Scope} in the
documentation page \link{firmly}). These are the expressions to check.}
}
\value{
Check formula of local scope.
}
\description{
These functions make check formulae of local scope based on the
correspondingly named \pkg{base} R predicates \code{is.*} (e.g.,
\code{vld_data_frame} corresponds to the predicate
\code{\link[base]{is.data.frame}}), with the following exceptions:
\code{vld_empty}, \code{vld_formula}, is based on the
\href{https://cran.r-project.org/package=purrr}{\pkg{purrr}} predicate
\code{\link[purrr]{is_empty}}, \code{\link[purrr]{is_formula}}, resp., and
\code{vld_number} is an alias for \code{vld_scalar_numeric}, which is based
on the predicate \code{function(x) is.numeric(x) && length(x) == 1L}.
\cr\cr
The checkers \code{vld_true} and \code{vld_false} assert that an expression
is identically \code{TRUE} or \code{FALSE}. They are all-purpose checkers to
specify \emph{arbitrary} input validation checks.
}
\details{
Each function \code{vld_*} is a function of class
  \code{"check_maker"}, generated by \code{\link{localize}}.
}
\examples{
\dontrun{

f <- function(x, y) "Pass"

# Impose the condition that x is a formula
g <- firmly(f, vld_formula(~x))
g(z ~ a + b, 0)  # [1] "Pass"
g(0, 0)          # Error: "Not formula: x"

# Impose the condition that x and y are disjoint (assuming they are vectors)
h <- firmly(f, vld_empty(~intersect(x, y)))
h(letters[1:3], letters[4:5])  # [1] "Pass"
h(letters[1:3], letters[3:5])  # Error: "Not empty: intersect(x, y)"

# Use a custom error message
h <- firmly(f, vld_empty("x, y must be disjoint" ~ intersect(x, y)))
h(letters[1:3], letters[3:5])  # Error: "x, y must be disjoint"

# vld_true can be used to implement any kind of input validation
ifelse_f <- firmly(ifelse, vld_true(~typeof(yes) == typeof(no)))
(w <- {set.seed(1); rnorm(5)})
# [1] -0.6264538  0.1836433 -0.8356286  1.5952808  0.3295078
ifelse_f(w > 0, 0, "1")  # Error: "Not TRUE: typeof(yes) == typeof(no)"
ifelse_f(w > 0, 0, 1)    # [1] 1 0 1 0 0
}

}
\alias{vld_array}
\alias{vld_call}
\alias{vld_complex}
\alias{vld_data_frame}
\alias{vld_empty}
\alias{vld_environment}
\alias{vld_expression}
\alias{vld_factor}
\alias{vld_false}
\alias{vld_formula}
\alias{vld_language}
\alias{vld_matrix}
\alias{vld_na}
\alias{vld_name}
\alias{vld_nan}
\alias{vld_number}
\alias{vld_numeric}
\alias{vld_ordered}
\alias{vld_pairlist}
\alias{vld_primitive}
\alias{vld_raw}
\alias{vld_recursive}
\alias{vld_scalar_numeric}
\alias{vld_symbol}
\alias{vld_table}
\alias{vld_true}
\alias{vld_unsorted}
\usage{
vld_array(...)

vld_call(...)

vld_complex(...)

vld_data_frame(...)

vld_empty(...)

vld_environment(...)

vld_expression(...)

vld_factor(...)

vld_false(...)

vld_formula(...)

vld_language(...)

vld_matrix(...)

vld_na(...)

vld_name(...)

vld_nan(...)

vld_number(...)

vld_numeric(...)

vld_ordered(...)

vld_pairlist(...)

vld_primitive(...)

vld_raw(...)

vld_recursive(...)

vld_scalar_numeric(...)

vld_symbol(...)

vld_table(...)

vld_true(...)

vld_unsorted(...)
}
\seealso{
Corresponding predicates: \code{\link[base]{is.array}}, \code{\link[base]{is.call}}, \code{\link[base]{is.complex}}, \code{\link[base]{is.data.frame}}, \code{\link[base]{is.environment}}, \code{\link[base]{is.expression}}, \code{\link[base]{is.factor}}, \code{\link[base]{is.language}}, \code{\link[base]{is.matrix}}, \code{\link[base]{is.na}}, \code{\link[base]{is.name}}, \code{\link[base]{is.nan}}, \code{\link[base]{is.numeric}}, \code{\link[base]{is.ordered}}, \code{\link[base]{is.pairlist}}, \code{\link[base]{is.primitive}}, \code{\link[base]{is.raw}}, \code{\link[base]{is.recursive}}, \code{\link[base]{is.symbol}}, \code{\link[base]{is.table}}, \code{\link[base]{is.unsorted}}, \code{\link[purrr]{is_empty}}, \code{\link[purrr]{is_formula}}

\code{\link{globalize}} recovers the underlying check formula of global scope.

The notions of \dQuote{scope} and \dQuote{check item} are explained in the \emph{Check Formulae} section of \link{firmly}.

Other checkers: \link{bare-type-checkers}, \link{scalar-type-checkers}, \link{type-checkers}
}
