% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/threshold.R
\name{rcut_threshold}
\alias{rcut_threshold}
\alias{rcut_threshold.default}
\alias{rcut_threshold.mlresult}
\title{Rank Cut (RCut) threshold method}
\usage{
rcut_threshold(prediction, k, probability = FALSE)

\method{rcut_threshold}{default}(prediction, k, probability = FALSE)

\method{rcut_threshold}{mlresult}(prediction, k, probability = FALSE)
}
\arguments{
\item{prediction}{A matrix or mlresult.}

\item{k}{The number of elements that will be positive.}

\item{probability}{A logical value. If \code{TRUE} the predicted values are
the score between 0 and 1, otherwise the values are bipartition 0 or 1.
(Default: \code{FALSE})}
}
\value{
A mlresult object.
}
\description{
The Rank Cut (RCut) method is an instance-wise strategy, which outputs the k
labels with the highest scores for each instance at the deployment.
}
\section{Methods (by class)}{
\itemize{
\item \code{default}: Rank Cut (RCut) threshold method for matrix

\item \code{mlresult}: Rank Cut (RCut) threshold method for mlresult
}}
\examples{
prediction <- matrix(runif(16), ncol = 4)
rcut_threshold(prediction, 2)
}
\references{
Al-Otaibi, R., Flach, P., & Kull, M. (2014). Multi-label Classification: A
 Comparative Study on Threshold Selection Methods. In First International
 Workshop on Learning over Multiple Contexts (LMCE) at ECML-PKDD 2014.
}
\seealso{
Other threshold: \code{\link{fixed_threshold}},
  \code{\link{lcard_threshold}},
  \code{\link{mcut_threshold}},
  \code{\link{pcut_threshold}},
  \code{\link{scut_threshold}},
  \code{\link{subset_correction}}
}

