% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tailplot.R
\name{tailplot}
\alias{tailplot}
\title{Generate tail plots for a data vector}
\usage{
tailplot(x, tail.prop = 0.05, left = TRUE, right = TRUE,
       show.lines = TRUE, lines = 16, line.order = 3,
       tail.plot = TRUE, hill.plot = FALSE, dsm.plot = FALSE,
       point.size = 3, point.alpha = 0.4,
       point.color = NULL, point.colour = point.color,
       line.color  = NULL, line.colour  = line.color,
       ytop.mult.left = 3, ytop.mult.right = 3)
}
\arguments{
\item{x}{Data vector (numeric)}

\item{tail.prop}{The proportion of values to use in each tail}

\item{left}{Logical; if \code{TRUE} the tail plot includes a plot for the left tail}

\item{right}{Logical; if \code{TRUE} the tail plot includes a plot for the upper tail}

\item{show.lines}{Logical; if \code{TRUE} the plots include lines for fixed logarithmic decay}

\item{lines}{Number of lines to include in the plot (included if \code{show.lines} is \code{TRUE})}

\item{line.order}{Order of the lines in the plot (included if \code{show.lines} is \code{TRUE})}

\item{tail.plot}{Logical; if \code{TRUE} the output includes the tail plot}

\item{hill.plot}{Logical; if \code{TRUE} the output includes the Hill plot}

\item{dsm.plot}{Logical; if \code{TRUE} the output includes the DSM plot}

\item{point.size}{Size of the points in the plots}

\item{point.alpha}{Alpha-transparency of the points in the plots}

\item{point.color, point.colour}{Colour of the points in the plots (default is blue)}

\item{line.color, line.colour}{Colour of the lines in the plots (default is darkred)}

\item{ytop.mult.left}{Multiplier used to determine the height of axis for left Hill/DSM plots}

\item{ytop.mult.right}{Multiplier used to determine the height of axis for right Hill/DSM plots}
}
\value{
Tail plots for the input data (and Hill plots or DSM plots if requested)
}
\description{
\code{tailplot} generates the tail plot and Hill plot for the input data
}
\details{
The tail plot for a dataset shows the rate of decay of the tails in the data.  It is used to
diagnose whether certain moments of the underlying distribution exist (e.g., the variance),
which is used in turn to determine whether certain statistical laws apply to the distribution
(e.g., the central limit theorem).  The Hill plot shows the adjusted Hill estimator for the tail
index of the distribution.  The DSM (De-Sousa-Michailidis) plot shows the adjusted DSM estimator
for the tail index of the distribution.  These latter estimators are very similar; more details
are found in the reference below.  Our adjusted versions of these estimators are computed using
data for the left and right deviations from the extreme values of the dataset; this is done to
ensure that the estimators are shift-invariant (the standard Hill and DSM estimators are not).

The present function produces tail plots and Hill/DSM plots for the input data vector to show
the rate of decay in the tails.  By default, both the tails are shown, but the user can show
the plots only for one tail if preferred.  The user can turn any of the plots on or off using
the inputs to the function.

By default, the tail plot includes lines showing cubic decay in the tails --- if the tails of
the distribution decay faster than cubic decay then the variance of the distribution exists.
The user can change the order of the lines in the plot to show other decay orders; this can be
used to diagnose the existence of moments of other orders.

De Sousa, B. and Michailidis, G. (2004) A Diagnostic Plot for Estimating the Tail Index of a
Distribution.  Journal of Computational and Graphical Statistics 13(4), pp. 1-22.
}
\examples{
try(tailplot(rnorm(500)))
}
