% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fitting_fns_triphasic.R
\name{get_optim_fit_triphasic}
\alias{get_optim_fit_triphasic}
\title{Fit triphasic model to data using optim}
\usage{
get_optim_fit_triphasic(initial_params, param_names, free_param_index,
  data, forward_param_transform_fn = forward_param_transform_fn,
  inv_param_transform_fn = inv_param_transform_fn, searchmethod)
}
\arguments{
\item{initial_params}{named vector of the initial parameter guess.}

\item{param_names}{names of parameter vector.}

\item{free_param_index}{logical vector indicating whether the parameters A, delta, A_b, delta_b, B, gamma are to be recovered. This should be c(TRUE, TRUE, TRUE, TRUE, TRUE, TRUE) for the triphasic model.}

\item{data}{dataframe with columns for the subject's viral load measurements ('vl'), and timing of sampling ('time')}

\item{forward_param_transform_fn}{list of transformation functions to be used when fitting the model in optim. Defaults to log transformations for all parameters (to allow unconstrained optimization).}

\item{inv_param_transform_fn}{list of transformation functions to be used when back-transforming the transformed parameters. Should be the inverse of the forward transformation functions. Defaults to exponential.}

\item{searchmethod}{optimization algorithm to be used in optim. Defaults to Nelder-Mead.}
}
\description{
This function uses optim to fit the triphasic model to data from a given subject
}
