% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/coordinates.r
\name{pol2cart}
\alias{pol2cart}
\title{pol2cart}
\usage{
pol2cart(r, theta, degrees = FALSE)
}
\arguments{
\item{r}{The radius of the point}

\item{theta}{The angle of the point, in radians}

\item{degrees}{Logical indicating if theta is specified in degrees}
}
\value{
A data.frame holding the (x,y) coordinates and original polar coordinates
}
\description{
Converts polar coordinates to caretsian coordinates
}
\details{
Converts polar coordinates to caretsian coordinates using a simple conversion.  The angle, \code{theta} must be in radians.

Somewhat inspired by http://www.r-bloggers.com/convert-polar-coordinates-to-cartesian/ and https://www.mathsisfun.com/polar-cartesian-coordinates.html
}
\examples{

polarRadPosTop <- data.frame(r=c(3, 5, 3, 5, 4, 6, 4, 6, 2), 
     theta=c(0, pi/6, pi/4, pi/3, pi/2, 2*pi/3, 3*pi/4, 5*pi/6, pi))
polarRadPosBottom <- data.frame(r=c(3, 5, 3, 5, 4, 6, 4, 6, 2), 
     theta=c(pi, 7*pi/6, 5*pi/4, 4*pi/3, 3*pi/2, 5*pi/3, 7*pi/4, 9*pi/6, 2*pi))
polarRadNegTop <- data.frame(r=c(3, 5, 3, 5, 4, 6, 4, 6, 2), 
     theta=-1*c(0, pi/6, pi/4, pi/3, pi/2, 2*pi/3, 3*pi/4, 5*pi/6, pi))
polarRadNegBottom <- data.frame(r=c(3, 5, 3, 5, 4, 6, 4, 6, 2), 
     theta=-1*c(pi, 7*pi/6, 5*pi/4, 4*pi/3, 3*pi/2, 5*pi/3, 7*pi/4, 9*pi/6, 2*pi))

pol2cart(polarRadPosTop$r, polarRadPosTop$theta)
pol2cart(polarRadPosBottom$r, polarRadPosBottom$theta)
pol2cart(polarRadNegTop$r, polarRadNegTop$theta)
pol2cart(polarRadNegBottom$r, polarRadNegBottom$theta)

}
\author{
Jared P. Lander
}

