% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/misc_and_utility.R
\name{umxPlotFun}
\alias{umxPlotFun}
\title{Easily plot functions in R}
\usage{
umxPlotFun(
  fun = dnorm,
  min = 0,
  max = 5,
  xlab = NULL,
  ylab = NULL,
  title = NULL,
  p = NULL
)
}
\arguments{
\item{fun}{Function to plot}

\item{min}{x min}

\item{max}{x max}

\item{xlab}{= Optional x axis label}

\item{ylab}{= Optional y axis label}

\item{title}{Optional title for the plot}

\item{p}{Optional plot onto which to draw the function.}
}
\value{
\itemize{
\item A ggplot graph
}
}
\description{
A wrapper for \code{\link[ggplot2:geom_function]{ggplot2::stat_function()}}
}
\details{
Easily plot a function - like sin, using ggplot.
}
\examples{
\dontrun{
# Uses fonts not available on CRAN
# Maybe call this funplot?
umxPlotFun(sin, max= 2*pi)


# Manually	
p = ggplot(data.frame(x = c(0, 10000)), aes(x))
p = p + ggplot2::stat_function(fun = function(x) decay(x, signal_loss$water), colour = "blue")
p = p + ggplot2::stat_function(fun = function(x) decay(x, signal_loss$white_matter), colour = "red")
}

}
\seealso{
\itemize{
\item \code{\link[ggplot2:geom_function]{ggplot2::stat_function()}}
}

Other Plotting functions: 
\code{\link{plot.MxLISRELModel}()},
\code{\link{plot.MxModel}()},
\code{\link{umxPlotACEcov}()},
\code{\link{umxPlotACEv}()},
\code{\link{umxPlotACE}()},
\code{\link{umxPlotCP}()},
\code{\link{umxPlotGxEbiv}()},
\code{\link{umxPlotGxE}()},
\code{\link{umxPlotIP}()},
\code{\link{umxPlotSexLim}()},
\code{\link{umxPlotSimplex}()},
\code{\link{umx}}
}
\concept{Plotting functions}
