% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/misc_and_utility.R
\name{umx_set_silent}
\alias{umx_set_silent}
\title{Print anything when running a model?}
\usage{
umx_set_silent(value = NA, silent = FALSE)
}
\arguments{
\item{value}{If TRUE mxRun is silent in most umx Models. Empty returns the current value.}

\item{silent}{If TRUE, no message will be printed.}
}
\value{
\itemize{
\item Current silent value
}
}
\description{
Sets a umx property "silent" to \code{TRUE} or \code{FALSE}. This is fed to \code{\link[OpenMx:mxRun]{OpenMx::mxRun()}} inside functions like \code{\link[=umxRAM]{umxRAM()}}.
If TRUE, then the progress messages from model runs are suppressed. Useful for power simulations etc.
}
\examples{
library(umx)
old = umx_set_silent() # print & store existing value
umx_set_silent(FALSE, silent = TRUE) # set to FALSE
umx_set_silent(old)   # reinstate
umx_set_silent() # print existing value
}
\references{
\itemize{
\item \url{https://tbates.github.io}, \url{https://github.com/tbates/umx}
}
}
\seealso{
Other Get and set: 
\code{\link{umx_get_checkpoint}()},
\code{\link{umx_get_options}()},
\code{\link{umx_set_auto_plot}()},
\code{\link{umx_set_auto_run}()},
\code{\link{umx_set_checkpoint}()},
\code{\link{umx_set_condensed_slots}()},
\code{\link{umx_set_cores}()},
\code{\link{umx_set_data_variance_check}()},
\code{\link{umx_set_optimization_options}()},
\code{\link{umx_set_optimizer}()},
\code{\link{umx_set_plot_file_suffix}()},
\code{\link{umx_set_plot_format}()},
\code{\link{umx_set_separator}()},
\code{\link{umx_set_table_format}()},
\code{\link{umx}}
}
\concept{Get and set}
