% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/misc_and_utility.R
\name{umx_set_auto_plot}
\alias{umx_set_auto_plot}
\title{umx_set_auto_plot}
\usage{
umx_set_auto_plot(autoPlot = NULL, silent = FALSE)
}
\arguments{
\item{autoPlot}{If TRUE, sets the umx_auto_plot option. Else returns the current value of umx_auto_plot}

\item{silent}{If TRUE, no message will be printed.}
}
\value{
\itemize{
\item Current umx_auto_plot setting
}

\itemize{
\item existing value
}
}
\description{
Set autoPlot default for models like umxACE umxGxE etc.
}
\examples{
library(umx)
umx_set_auto_plot() # print current state
old = umx_set_auto_plot(silent = TRUE) # store existing value
old
umx_set_auto_plot(TRUE)   # set to on (internally stored as "name")
umx_set_auto_plot(FALSE)  # set to off (internally stored as NA)
umx_set_auto_plot(old)    # reinstate
}
\references{
\itemize{
\item \url{https://tbates.github.io},  \url{https://github.com/tbates/umx}
}
}
\seealso{
Other Get and set: 
\code{\link{umx_get_checkpoint}()},
\code{\link{umx_get_options}()},
\code{\link{umx_set_auto_run}()},
\code{\link{umx_set_checkpoint}()},
\code{\link{umx_set_condensed_slots}()},
\code{\link{umx_set_cores}()},
\code{\link{umx_set_data_variance_check}()},
\code{\link{umx_set_optimization_options}()},
\code{\link{umx_set_optimizer}()},
\code{\link{umx_set_plot_file_suffix}()},
\code{\link{umx_set_plot_format}()},
\code{\link{umx_set_separator}()},
\code{\link{umx_set_silent}()},
\code{\link{umx_set_table_format}()},
\code{\link{umx}}
}
\concept{Get and set}
