% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/xmu.R
\name{xmu_twin_check}
\alias{xmu_twin_check}
\title{Check basic aspects of input for twin models.}
\usage{
xmu_twin_check(
  selDVs,
  dzData = dzData,
  mzData = mzData,
  sep = NULL,
  enforceSep = TRUE,
  nSib = 2,
  numObsMZ = NULL,
  numObsDZ = NULL,
  optimizer = NULL
)
}
\arguments{
\item{selDVs}{Variables used in the data.}

\item{dzData}{The DZ twin data.}

\item{mzData}{The MZ twin data.}

\item{sep}{Separator between base-name and numeric suffix when creating variable names, e.g. "_T"}

\item{enforceSep}{Whether to require sep to be set, or just warn if it is not (Default = TRUE: enforce).}

\item{nSib}{How many people per family? (Default = 2).}

\item{numObsMZ}{set if data are not raw.}

\item{numObsDZ}{set if data are not raw.}

\item{optimizer}{Set by name (if you want to change it).}
}
\value{
None
}
\description{
Check that DVs are in the data, that the data have rows, set the optimizer if requested.
}
\examples{
library(umx)
data(twinData)
mzData = subset(twinData, zygosity == "MZFF")
dzData = subset(twinData, zygosity == "MZFF")
xmu_twin_check(selDVs = c("wt", "ht"), dzData = dzData, mzData = mzData, 
	sep = "", enforceSep = TRUE)
xmu_twin_check(selDVs = c("wt", "ht"), dzData = dzData, mzData = mzData, 
	sep = "", enforceSep = FALSE)
xmu_twin_check(selDVs = c("wt", "ht"), dzData = dzData, mzData = mzData, 
	sep = "", enforceSep = TRUE, nSib = 2, optimizer = NULL)

\dontrun{
# TODO xmu_twin_check: move to a test file:
# 1. stop on no rows
xmu_twin_check("Generativity", twinData[NULL,], twinData[NULL,], sep="_T")
# Error in xmu_twin_check("Generativity", twinData[NULL, ], twinData[NULL,  : 
#   Your DZ dataset has no rows!

# 2. Stop on a NULL sep  = NULL IFF enforceSep = TRUE
xmu_twin_check(selDVs = c("wt", "ht"), dzData = dzData, mzData = mzData, enforceSep = TRUE)
# 3. stop on a factor with sep = NULL
}
}
\references{
\itemize{
\item \url{https://github.com/tbates/umx}, \url{https://tbates.github.io}
}
}
\seealso{
Other xmu internal not for end user: \code{\link{umxModel}()},
  \code{\link{umx_standardize}()}, \code{\link{umx}},
  \code{\link{xmuHasSquareBrackets}()},
  \code{\link{xmuLabel_MATRIX_Model}()},
  \code{\link{xmuLabel_Matrix}()},
  \code{\link{xmuLabel_RAM_Model}()},
  \code{\link{xmuMI}()},
  \code{\link{xmuMakeDeviationThresholdsMatrices}()},
  \code{\link{xmuMakeOneHeadedPathsFromPathList}()},
  \code{\link{xmuMakeTwoHeadedPathsFromPathList}()},
  \code{\link{xmuMaxLevels}()},
  \code{\link{xmuMinLevels}()},
  \code{\link{xmuPropagateLabels}()},
  \code{\link{xmu_CI_merge}()},
  \code{\link{xmu_CI_stash}()},
  \code{\link{xmu_DF_to_mxData_TypeCov}()},
  \code{\link{xmu_PadAndPruneForDefVars}()},
  \code{\link{xmu_assemble_twin_supermodel}()},
  \code{\link{xmu_check_levels_identical}()},
  \code{\link{xmu_check_needs_means}()},
  \code{\link{xmu_check_variance}()},
  \code{\link{xmu_clean_label}()},
  \code{\link{xmu_describe_data_WLS}()},
  \code{\link{xmu_dot_make_paths}()},
  \code{\link{xmu_dot_make_residuals}()},
  \code{\link{xmu_dot_maker}()},
  \code{\link{xmu_dot_move_ranks}()},
  \code{\link{xmu_dot_rank_str}()},
  \code{\link{xmu_get_CI}()},
  \code{\link{xmu_lavaan_process_group}()},
  \code{\link{xmu_make_bin_cont_pair_data}()},
  \code{\link{xmu_make_mxData}()},
  \code{\link{xmu_make_top_twin}()},
  \code{\link{xmu_name_from_lavaan_str}()},
  \code{\link{xmu_safe_run_summary}()},
  \code{\link{xmu_set_sep_from_suffix}()},
  \code{\link{xmu_show_fit_or_comparison}()},
  \code{\link{xmu_simplex_corner}()},
  \code{\link{xmu_standardize_ACEcov}()},
  \code{\link{xmu_standardize_ACEv}()},
  \code{\link{xmu_standardize_ACE}()},
  \code{\link{xmu_standardize_CP}()},
  \code{\link{xmu_standardize_IP}()},
  \code{\link{xmu_standardize_RAM}()},
  \code{\link{xmu_standardize_SexLim}()},
  \code{\link{xmu_standardize_Simplex}()},
  \code{\link{xmu_start_value_list}()},
  \code{\link{xmu_starts}()}
}
\concept{xmu internal not for end user}
