% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/xmu.R
\name{xmu_check_variance}
\alias{xmu_check_variance}
\title{Check the minimum variance in data frame}
\usage{
xmu_check_variance(
  data,
  minVar = umx_set_data_variance_check(silent = T)$minVar,
  maxVarRatio = umx_set_data_variance_check(silent = T)$maxVarRatio
)
}
\arguments{
\item{data}{the data frame to check}

\item{minVar}{Minimum allowed variance in variables before warning user variances differ too much.}

\item{maxVarRatio}{Maximum allowed ratio of variance in data before warning user variances differ too much.}
}
\value{
None
}
\description{
Check that each variable exceeds a minimum variance and all are on compatible scales. Let the user know what to do if not.
}
\examples{
data(twinData)
xmu_check_variance(twinData[, c("wt1", "ht1", "wt2", "ht2")])
twinData[,c("ht1", "ht2")]= twinData[,c("ht1", "ht2")] * 100
xmu_check_variance(twinData[, c("wt1", "ht1", "wt2", "ht2")])
}
\seealso{
Other xmu internal not for end user: \code{\link{umxModel}()},
  \code{\link{umx_standardize}()}, \code{\link{umx}},
  \code{\link{xmuHasSquareBrackets}()},
  \code{\link{xmuLabel_MATRIX_Model}()},
  \code{\link{xmuLabel_Matrix}()},
  \code{\link{xmuLabel_RAM_Model}()},
  \code{\link{xmuMI}()},
  \code{\link{xmuMakeDeviationThresholdsMatrices}()},
  \code{\link{xmuMakeOneHeadedPathsFromPathList}()},
  \code{\link{xmuMakeTwoHeadedPathsFromPathList}()},
  \code{\link{xmuMaxLevels}()},
  \code{\link{xmuMinLevels}()},
  \code{\link{xmuPropagateLabels}()},
  \code{\link{xmu_CI_merge}()},
  \code{\link{xmu_CI_stash}()},
  \code{\link{xmu_DF_to_mxData_TypeCov}()},
  \code{\link{xmu_PadAndPruneForDefVars}()},
  \code{\link{xmu_assemble_twin_supermodel}()},
  \code{\link{xmu_check_levels_identical}()},
  \code{\link{xmu_check_needs_means}()},
  \code{\link{xmu_clean_label}()},
  \code{\link{xmu_describe_data_WLS}()},
  \code{\link{xmu_dot_make_paths}()},
  \code{\link{xmu_dot_make_residuals}()},
  \code{\link{xmu_dot_maker}()},
  \code{\link{xmu_dot_move_ranks}()},
  \code{\link{xmu_dot_rank_str}()},
  \code{\link{xmu_get_CI}()},
  \code{\link{xmu_lavaan_process_group}()},
  \code{\link{xmu_make_bin_cont_pair_data}()},
  \code{\link{xmu_make_mxData}()},
  \code{\link{xmu_make_top_twin}()},
  \code{\link{xmu_name_from_lavaan_str}()},
  \code{\link{xmu_safe_run_summary}()},
  \code{\link{xmu_set_sep_from_suffix}()},
  \code{\link{xmu_show_fit_or_comparison}()},
  \code{\link{xmu_simplex_corner}()},
  \code{\link{xmu_standardize_ACEcov}()},
  \code{\link{xmu_standardize_ACEv}()},
  \code{\link{xmu_standardize_ACE}()},
  \code{\link{xmu_standardize_CP}()},
  \code{\link{xmu_standardize_IP}()},
  \code{\link{xmu_standardize_RAM}()},
  \code{\link{xmu_standardize_SexLim}()},
  \code{\link{xmu_standardize_Simplex}()},
  \code{\link{xmu_start_value_list}()},
  \code{\link{xmu_starts}()},
  \code{\link{xmu_twin_check}()}
}
\concept{xmu internal not for end user}
