% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/misc_and_utility.R
\name{umx_rename_file}
\alias{umx_rename_file}
\title{Rename files}
\usage{
umx_rename_file(findStr = NA, replaceStr = NA, baseFolder = "Finder",
  listPattern = NA, test = TRUE, overwrite = FALSE)
}
\arguments{
\item{findStr}{The (regex) string to find, i.e., "cat"}

\item{replaceStr}{The (regex) replacement string "\1 are not dogs"}

\item{baseFolder}{The folder to search in. If set to "Finder" (and you are on OS X) it will use the current front-most Finder window. If it is blank, a choose folder dialog will be thrown.}

\item{listPattern}{A pre-filter for files}

\item{test}{Boolean determining whether to change files on disk, or just report on what would have happened (Defaults to test = TRUE)}

\item{overwrite}{Boolean determining if an existing file will be overwritten (Defaults to the safe FALSE)}
}
\value{
None
}
\description{
Rename files. On OS X, the function can access the current front-most Finder window.
The file renaming is fast and, because you can use regular expressions, powerful.
}
\examples{
\dontrun{
# "Season 01" --> "S01" in current folder in MacOS Finder
umx_rename_file("[Ss]eason +([0-9]+)", replaceStr="S\\1", baseFolder = "Finder", test = TRUE)
}
}
\references{
\itemize{
\item \url{https://www.github.com/tbates/umx}
}
}
\seealso{
Other File Functions: \code{\link{dl_from_dropbox}()},
  \code{\link{umx_make_sql_from_excel}()},
  \code{\link{umx_move_file}()}, \code{\link{umx_open}()},
  \code{\link{umx_write_to_clipboard}()}, \code{\link{umx}}
}
\concept{File Functions}
