% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/misc_and_utility.R
\name{umx_fix_first_loadings}
\alias{umx_fix_first_loadings}
\title{umx_fix_first_loadings}
\usage{
umx_fix_first_loadings(model, latents = NULL, at = 1)
}
\arguments{
\item{model}{An \code{\link{mxModel}} to set.}

\item{latents}{Which latents to fix from (NULL = all).}

\item{at}{The value to fix the first path at (Default = 1).}
}
\value{
- \code{\link{mxModel}}
}
\description{
Fix the loading of the first path from each latent at selected value. 
Note: latents with fixed variance are skipped.
}
\examples{
require(umx)
data(demoOneFactor)
m1 <- mxModel("One Factor", type = "RAM",
 manifestVars = names(demoOneFactor),
 latentVars = "g",
	mxPath(from = "g", to = names(demoOneFactor)),
	mxPath(from = names(demoOneFactor), arrows = 2),
	mxData(cov(demoOneFactor), type = "cov", numObs = 500)
)
m1 = umx_fix_first_loadings(m1)
umx_show(m1) # path from g to var1 fixed @ 1.
}
\references{
- \url{https://tbates.github.io}, \url{https://github.com/tbates/umx}, \url{https://openmx.ssri.psu.edu}
}
\seealso{
Other Advanced Model Building Functions: \code{\link{umxJiggle}},
  \code{\link{umxLabel}}, \code{\link{umxLatent}},
  \code{\link{umxRAM2Ordinal}},
  \code{\link{umxThresholdMatrix}},
  \code{\link{umxValues}}, \code{\link{umx_add_variances}},
  \code{\link{umx_fix_latents}},
  \code{\link{umx_get_bracket_addresses}},
  \code{\link{umx_string_to_algebra}}, \code{\link{umx}}
}
\concept{Advanced Model Building Functions}
