% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/faConfInt.R
\name{faConfInt}
\alias{faConfInt}
\title{Extract confidence bounds from psych's factor analysis object}
\usage{
faConfInt(fa)
}
\arguments{
\item{fa}{The object produced by the \code{\link[psych:fa]{psych::fa()}} function from the
\link[psych:psych-package]{psych::psych-package} package. It is important that the \code{n.iter} argument
of\code{\link[psych:fa]{psych::fa()}} was set to a realistic number, because otherwise, no
confidence intervals will be available.}
}
\value{
A list of dataframes, one for each extracted factor, with in each
dataframe three variables: \item{lo}{lower bound of the confidence interval}
\item{est}{point estimate of the factor loading} \item{hi}{upper bound of
the confidence interval}
}
\description{
This function contains some code from a function in \link[psych:psych-package]{psych::psych-package}
that's not exported \code{print.psych.fa.ci} but useful nonetheless. It
basically takes the outcomes of a factor analysis and extracted the
confidence intervals.
}
\details{
THis function extract confidence interval bounds and combines them with
factor loadings using the code from the \code{print.psych.fa.ci} in
\link[psych:psych-package]{psych::psych-package}.
}
\examples{

\dontrun{
### Not run because it takes too long to run to test it,
### and may produce warnings, both because of the bootstrapping
### required to generate the confidence intervals in fa
faConfInt(psych::fa(Thurstone.33, 2, n.iter=100, n.obs=100));
}

}
\author{
William Revelle (extracted by Gjalt-Jorn Peters)

Maintainer: Gjalt-Jorn Peters \href{mailto:gjalt-jorn@userfriendlyscience.com}{gjalt-jorn@userfriendlyscience.com}
}
