% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/formatCI.R
\name{formatCI}
\alias{formatCI}
\title{Pretty formatting of confidence intervals}
\usage{
formatCI(ci, sep = "; ", prefix = "[", suffix = "]", digits = 2,
  noZero = FALSE)
}
\arguments{
\item{ci}{A confidence interval (a vector of 2 elements; longer
vectors work, but I guess that wouldn't make sense).}

\item{sep}{The separator of the values, usually "; " or ", ".}

\item{prefix, suffix}{The prefix and suffix, usually a type of
opening and closing parenthesis/bracket.}

\item{digits}{The number of digits to which to round the values.}

\item{noZero}{Whether to strip the leading zero (before the decimal
point), as is typically done when following APA style and
displaying correlations, \emph{p} values, and other numbers that cannot
reach 1 or more.}
}
\value{
A character vector of one element.
}
\description{
Pretty formatting of confidence intervals
}
\examples{
### With leading zero ...
formatCI(c(0.55, 0.021));

### ... and without
formatCI(c(0.55, 0.021), noZero=TRUE);
}
\seealso{
\code{\link[=noZero]{noZero()}}, \code{\link[=formatR]{formatR()}}, \code{\link[=formatPvalue]{formatPvalue()}}
}
