% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/occu.R
\name{stan_occu}
\alias{stan_occu}
\title{Fit the MacKenzie et al. (2002) Occupancy Model}
\usage{
stan_occu(formula, data, ...)
}
\arguments{
\item{formula}{Double right-hand side formula describing covariates of
detection and occupancy in that order}

\item{data}{A \code{\link{unmarkedFrameOccu}} object}

\item{...}{Arguments passed to the \code{\link{stan}} call, such as
number of chains \code{chains} or iterations \code{iter}}
}
\value{
\code{ubmsFitOccu} object describing the model fit.
}
\description{
This function fits the single season occupancy model of
MacKenzie et al. (2002).
}
\examples{
\donttest{
data(frogs)
pferUMF <- unmarkedFrameOccu(pfer.bin)

#Add some covariates
siteCovs(pferUMF) <- data.frame(cov1=rnorm(numSites(pferUMF)))

#Fit model
(fm <- stan_occu(~1~cov1, pferUMF, chains=3, iter=300))
}

}
\references{
MacKenzie DI, Nichols JD, Lachman GB, Droege S, Royle JA,
 Langtimm CA. 2002. Estimating site occupancy rates when detection
 probabilities are less than one. Ecology 83: 2248-2255.
}
\seealso{
\code{\link{occu}}, \code{\link{unmarkedFrameOccu}}
}
