% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/convert_date_to_numeric.R
\name{max_cycle_length}
\alias{max_cycle_length}
\title{Calculate the Maximum Possible Value of a Time Cycle}
\usage{
max_cycle_length(cycle_length, time_scale)
}
\arguments{
\item{cycle_length}{A character string indicating the larger unit of time.
It must be one of "year", "month", "day", "hour", "minute".}

\item{time_scale}{A character string indicating the smaller unit of time,
which is a division of the \code{cycle_length}. If \code{cycle_length} is "year",
\code{time_scale} can be one of "month", "day", "hour", "minute", "second".
If \code{cycle_length} is "month", \code{time_scale} can be "day", "hour", "minute",
"second", and so on.}
}
\value{
The function returns the maximum possible value that the \code{time_scale}
can take within one \code{cycle_length}.
}
\description{
This function returns the maximum possible value that a specific time
component can take, given a cycle length and scale.
}
\examples{

max_cycle_length("year", "month")  # Maximum months is a year 12
max_cycle_length("day", "minute")  # Maximum minutes in a day 1440
max_cycle_length("year", "day")    # Maximum days in a year 366

}
