% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/list_channel_videos.R
\name{list_channel_videos}
\alias{list_channel_videos}
\title{Returns List of Requested Channel Videos}
\usage{
list_channel_videos(channel_id = NULL, max_results = 50,
  page_token = NULL, hl = "en-US", ...)
}
\arguments{
\item{channel_id}{String. ID of the channel. Required.}

\item{max_results}{Maximum number of playlists from which the videos
should be returned. Integer. Default is 50.}

\item{page_token}{Specific page in the result set that should be returned. Optional.}

\item{hl}{Language used for text values. Optional. Default is \code{en-US}. For other allowed language codes, see \code{\link{list_langs}}}

\item{\dots}{Additional arguments passed to \code{\link{tuber_GET}}.}
}
\value{
list of \code{data.frame} with each list corresponding to a different
playlist
}
\description{
Iterate through the \code{max_results} number of playlists in channel and get
the videos for each of the playlists.
}
\examples{

\dontrun{

# Set API token via yt_oauth() first

list_channel_videos(channel_id = "UCXOKEdfOFxsHO_-Su3K8SHg")
list_channel_videos(channel_id = "UCXOKEdfOFxsHO_-Su3K8SHg", max_results = 10)
}
}
\references{
\url{https://developers.google.com/youtube/v3/docs/channels/list}
}
