% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_builddata.R
\name{get_builddata}
\alias{get_builddata}
\title{Function to retrieve customized U.S. construction spending data.}
\usage{
get_builddata(host = NA, startyear, endyear)
}
\arguments{
\item{host}{The Correlates of War (COW) numeric country code or ISO3C code for the host country or countries in the series}

\item{startyear}{The first year for the series}

\item{endyear}{The last year for the series}
}
\value{
\code{get_builddata()} returns a data frame containing location-project-year observations of U.S. military construction and housing spending in thousands of current dollars.
}
\description{
\code{get_builddata()} generates a customized data frame containing location-project-year observations of U.S. military construction and housing spending in thousands of current dollars.
}
\examples{

\dontrun{
library(tidyverse)
library(troopdata)

example <- get_builddata(host = NA, startyear = 2008, endyear = 2019)

head(example)

}



}
\references{
Michael A. Allen, Michael E. Flynn, and Carla Martinez Machain. 2020. "Outside the wire: US military deployments and public opinion in host states." American Political Science Review. 114(2): 326-341.
}
\author{
Michael E. Flynn
}
