% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/transform_if.R
\name{transform_if}
\alias{transform_if}
\title{The transform_if function}
\usage{
transform_if(x, cond, yes = function(x) x, no = function(x) x, other = NA)
}
\arguments{
\item{x}{a vector, matrix, or array.}

\item{cond}{either an object of class \code{logical} with the same length as \code{x}, \cr
or a (possibly anonymous) function that returns an object of class \code{logical}
with the same length as \code{x}. \cr
For example: \code{\(x)x>0}. \cr}

\item{yes}{the (possibly anonymous) transformation function to use
when function \code{cond(x)==TRUE} / logical \code{cond==TRUE}. \cr
Alternatively, one can also supply an atomic scalar. \cr
If argument \code{yes} is not specified, it defaults to \code{\(x)x}.}

\item{no}{the (possibly anonymous) transformation function to use
when function \code{cond(x)==FALSE} / logical \code{cond==FALSE}. \cr
Alternatively, one can also supply an atomic scalar. \cr
If argument \code{no} is not specified, it defaults to \code{\(x)x}.}

\item{other}{the (possibly anonymous) transformation function to use
when function \code{cond(x)} / logical \code{cond} returns \code{NA}. \cr
Alternatively, one can also supply an atomic scalar. \cr
If argument \code{other} is not specified, it defaults to \code{NA}. \cr
Note that function  \code{other(x)} is run or scalar \code{other} is returned
when function \code{cond(x)} or logical \code{cond} is \code{NA},
not necessarily when \code{x} itself is \code{NA}.}
}
\value{
The transformed vector, matrix, or array (attributes are conserved).
}
\description{
The \code{transform_if()} function transforms an object \code{x},
based on the logical result (\code{TRUE, FALSE, NA})
of condition function \code{cond(x)} or logical vector \code{cond},
such that: \cr

\itemize{
\item For every value where \code{cond(x)==TRUE} / \code{cond==TRUE},
function \code{yes(x)} is run or scalar \code{yes} is returned.
\item For every value where \code{cond(x)==FALSE} / \code{cond==FALSE},
function \code{no(x)} is run or scalar \code{no} is returned.
\item For every value where \code{cond(x)==NA} / \code{cond==NA},
function \code{other(x)} is run or scalar \code{other} is returned. \cr
}
}
\details{
Be careful with coercion! For example the following code:

\if{html}{\out{<div class="sourceCode r">}}\preformatted{x <- c("a", "b")
transform_if(x, \\(x)x=="a", as.numeric, as.logical)
}\if{html}{\out{</div>}}

returns:

\if{html}{\out{<div class="sourceCode r">}}\preformatted{[1] NA NA
}\if{html}{\out{</div>}}

due to the same character vector being given 2 incompatible classes. \cr
\cr
}
\examples{
x <- c(-10:9, NA, NA)
object <- matrix(x, ncol=2)
attr(object, "helloworld") <- "helloworld"
print(object)
y <- 0
z <- 1000

object |> transform_if(\(x)x>y, log, \(x)x^2, \(x)-z)
object |> transform_if(object > y, log, \(x)x^2, -z) # same as previous line

}
\seealso{
\code{\link[=tinycodet_dry]{tinycodet_dry()}}
}
