% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pmc_table.R
\name{pmc_table}
\alias{pmc_table}
\title{Convert table nodes to tibbles}
\usage{
pmc_table(doc)
}
\arguments{
\item{doc}{\code{xml_document} from PubMed Central}
}
\value{
a list of tibbles
}
\description{
Convert PubMed Central table nodes into a list of tibbles
}
\note{
Saves the caption and footnotes as attributes and collapses multiline
headers, expands all rowspan and colspan attributes and adds
subheadings to column one.
}
\examples{
# doc <- pmc_xml("PMC2231364")
doc <- xml2::read_xml(system.file("extdata/PMC2231364.xml",
  package = "tidypmc"
))
x <- pmc_table(doc)
sapply(x, dim)
x
attributes(x[[1]])
}
\author{
Chris Stubben
}
