% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fill.R
\name{fill}
\alias{fill}
\alias{shift_fill}
\title{Fill in missing values with previous or next value}
\usage{
fill(.data, ..., direction = "down")

shift_fill(x, direction = "down")
}
\arguments{
\item{.data}{A data.table}

\item{...}{A selection of columns.}

\item{direction}{Direction in which to fill missing values.
Currently either "down" (the default), "up".}

\item{x}{A vector.}
}
\value{
A filled data.table
}
\description{
Fills missing values in selected columns using the next or previous entry.
}
\details{
\code{fill} is filling data.table's columns,
 \code{shift_fill} is filling any vectors.
}
\examples{

df <- data.table(Month = 1:12, Year = c(2000, rep(NA, 10),2001))
df
df \%>\% fill(Year)

df <- data.table(Month = 1:12, Year = c(2000, rep(NA, 10),2001))
df \%>\% fill(Year,direction = "up")

}
