% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/min_var.R
\name{min_var}
\alias{min_var}
\title{Select columns with minimum amount of variance}
\usage{
min_var(x, min = 1)
}
\arguments{
\item{x}{Input data, which should be either a data frame or matrix.}

\item{min}{Minimum amount of variance to require per column.}
}
\value{
Returns data frame (or matrix, depending on input class) with all non-numeric
  columns and only those numeric columns that meet the minimum amount of variance.
}
\description{
Filters numeric columns by requiring a minimum amount of variance
}
\details{
This function omits missing values.
}
\examples{

## set seed (for replication purposes)
set.seed(206195)

## create data set
d <- data_set(
  w = rnorm(100, 0, 0.0),
  v = rnorm(100, 0, 0.5),
  x = rnorm(100, 0, 1.0),
  y = rnorm(100, 0, 2.0),
  z = rnorm(100, 0, 3.0)
)

## minimum var of 1.0 (default)
min_var(d)

## min variance of 0.1
min_var(d, 0.1)

## min var of 2.0
min_var(d, 2.0)

## min var of 6.0
min_var(d, 6.0)

}
