% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/col_style_plan.R
\name{col_style_structure}
\alias{col_style_structure}
\title{Column Style Structure}
\usage{
col_style_structure(col, align = NULL, width = NULL, ...)
}
\arguments{
\item{col}{Column value to align on from \code{column} variable. May be a quoted
or unquoted column name, a tidyselect semantic, or a span_structure.}

\item{align}{Alignment to be applied to column. Acceptable values: "left" for
left alignment, "right" for right alignment", or supply a vector of
character(s) to align on. For the case of character alignment, if more than
one character is provided, alignment will be based on the first occurrence
of any of the characters. For alignment based on white space, leading white
spaces will be ignored.}

\item{width}{Width to apply to the column in number of characters. Acceptable values include a
numeric value, or a character string of a number.}

\item{...}{These dots are for future extensions and must be empty}
}
\value{
col_style_structure object
}
\description{
Column Style Structure
}
\details{
Supports alignment and width setting of data value columns (values found in the \code{column} column). Row group and label
columns are left-aligned by default.
}
\examples{

 plan <- col_style_plan(
    col_style_structure(align = "left", width = 100, col = "my_var"),
    col_style_structure(align = "right", width = 200, col = vars(four)),
    col_style_structure(align = c(".", ",", " "), col = vars(two, three)),
    col_style_structure(width = 25, col = c(two, three)),
    col_style_structure(width = 25, col = two),
    col_style_structure(width = 25, col = span_structure(span = value, col = val2))
   )

}
\seealso{
\code{\link[=col_style_plan]{col_style_plan()}} for more information on how to combine
col_style_structure()'s together to form a plan.

\href{https://gsk-biostatistics.github.io/tfrmt/articles/col_style_plan.html}{Link to related article}
}
