% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/apply_frmt_methods.R
\name{apply_frmt}
\alias{apply_frmt}
\alias{apply_frmt.frmt}
\alias{apply_frmt.frmt_combine}
\alias{apply_frmt.frmt_when}
\title{Apply formatting}
\usage{
apply_frmt(frmt_def, .data, value, mock = FALSE, ...)

\method{apply_frmt}{frmt}(frmt_def, .data, value, mock = FALSE, ...)

\method{apply_frmt}{frmt_combine}(
  frmt_def,
  .data,
  value,
  mock = FALSE,
  param,
  column,
  label,
  group,
  ...
)

\method{apply_frmt}{frmt_when}(frmt_def, .data, value, mock = FALSE, ...)
}
\arguments{
\item{frmt_def}{formatting to be applied}

\item{.data}{data, but only what is getting changed}

\item{value}{value symbol should only be one}

\item{mock}{Logical value is this is for a mock or not. By default \code{FALSE}}

\item{...}{additional arguments for methods}

\item{param}{param column as a quosure}

\item{column}{column columns as a list of quosures}

\item{label}{label column as a quosure}

\item{group}{group column as a list of quosures}
}
\value{
formatted dataset
}
\description{
Apply formatting
}
\examples{

library(tibble)
library(dplyr)
# Set up data
df <- tibble(x = c(20.12,34.54,12.34))

apply_frmt(
 frmt_def = frmt("XX.X"),
 .data=df,
 value=quo(x))

}
