% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/stem.R
\name{step_stem}
\alias{step_stem}
\title{Stemming of Token Variables}
\usage{
step_stem(
  recipe,
  ...,
  role = NA,
  trained = FALSE,
  columns = NULL,
  options = list(),
  custom_stemmer = NULL,
  skip = FALSE,
  id = rand_id("stem")
)
}
\arguments{
\item{recipe}{A \link{recipe} object. The step will be added to the
sequence of operations for this recipe.}

\item{...}{One or more selector functions to choose which
variables are affected by the step. See \code{\link[recipes:selections]{recipes::selections()}}
for more details.}

\item{role}{Not used by this step since no new variables are
created.}

\item{trained}{A logical to indicate if the quantities for
preprocessing have been estimated.}

\item{columns}{A character string of variable names that will
be populated (eventually) by the \code{terms} argument. This is \code{NULL}
until the step is trained by \code{\link[recipes:prep]{recipes::prep.recipe()}}.}

\item{options}{A list of options passed to the stemmer function.}

\item{custom_stemmer}{A custom stemming function. If none is provided it will
default to "SnowballC".}

\item{skip}{A logical. Should the step be skipped when the
recipe is baked by \code{\link[recipes:bake]{recipes::bake.recipe()}}? While all operations are baked
when \code{\link[recipes:prep]{recipes::prep.recipe()}} is run, some operations may not be able to be
conducted on new data (e.g. processing the outcome variable(s)).
Care should be taken when using \code{skip = FALSE}.}

\item{id}{A character string that is unique to this step to identify it.}
}
\value{
An updated version of \code{recipe} with the new step added
to the sequence of existing steps (if any).
}
\description{
\code{step_stem} creates a \emph{specification} of a recipe step that will convert a
\code{\link[=tokenlist]{token}} variable to have its stemmed version.
}
\details{
Words tend to have different forms depending on context, such as organize,
organizes, and organizing. In many situations it is beneficial to have these
words condensed into one to allow for a smaller pool of words. Stemming is
the act of chopping off the end of words using a set of heuristics.

Note that the stemming will only be done at the end of the word and will
therefore not work reliably on ngrams or sentences.
}
\section{Tidying}{
When you \code{\link[=tidy.recipe]{tidy()}} this step, a tibble with columns \code{terms}
(the selectors or variables selected) and \code{is_custom_stemmer} (indicate if
custom stemmer was used).
}

\examples{
library(recipes)
library(modeldata)
data(tate_text)

tate_rec <- recipe(~., data = tate_text) \%>\%
  step_tokenize(medium) \%>\%
  step_stem(medium)

tate_obj <- tate_rec \%>\%
  prep()

bake(tate_obj, new_data = NULL, medium) \%>\%
  slice(1:2)

bake(tate_obj, new_data = NULL) \%>\%
  slice(2) \%>\%
  pull(medium)

tidy(tate_rec, number = 2)
tidy(tate_obj, number = 2)

# Using custom stemmer. Here a custom stemmer that removes the last letter
# if it is a "s".
remove_s <- function(x) gsub("s$", "", x)

tate_rec <- recipe(~., data = tate_text) \%>\%
  step_tokenize(medium) \%>\%
  step_stem(medium, custom_stemmer = remove_s)

tate_obj <- tate_rec \%>\%
  prep()

bake(tate_obj, new_data = NULL, medium) \%>\%
  slice(1:2)

bake(tate_obj, new_data = NULL) \%>\%
  slice(2) \%>\%
  pull(medium)
}
\seealso{
\code{\link[=step_tokenize]{step_tokenize()}} to turn characters into \code{\link[=tokenlist]{tokens}}

Other Steps for Token Modification: 
\code{\link{step_lemma}()},
\code{\link{step_ngram}()},
\code{\link{step_pos_filter}()},
\code{\link{step_stopwords}()},
\code{\link{step_tokenfilter}()},
\code{\link{step_tokenmerge}()}
}
\concept{Steps for Token Modification}
