% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{Gibbs_AS_posteriorCPP}
\alias{Gibbs_AS_posteriorCPP}
\title{Use a Gibbs sampler for the A and S variables (E-step of the EM)}
\usage{
Gibbs_AS_posteriorCPP(
  nsamp,
  nburn,
  template_mean,
  template_var,
  S,
  G,
  tau_v,
  Y,
  alpha,
  final,
  return_samp
)
}
\arguments{
\item{nsamp}{the number of posterior samples to output after burn-in}

\item{nburn}{the number of posterior samples to throw away before saving}

\item{template_mean}{a matrix with dimensions V x Q giving the mean value
of the independent components}

\item{template_var}{a matrix with dimensions V x Q giving the variance
of the independent components}

\item{S}{a matrix with dimensions V x Q of subject independent components}

\item{G}{a Q x Q matrix of the prior covariance of A}

\item{tau_v}{a length V vector with noise variance for each data location}

\item{Y}{a matrix with dimensions V x T of observed BOLD data}

\item{alpha}{a length Q vector of the prior mean of all rows of A}

\item{final}{a boolean. Should posterior samples be returned instead of
summary measures?}

\item{return_samp}{a boolean. Should posterior samples be returned?}
}
\value{
List with estimates for A, S, and possibly other quantities
}
\description{
Use a Gibbs sampler for the A and S variables (E-step of the EM)
}
