% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/plots.R
\name{vis.heatmap}
\alias{vis.heatmap}
\title{Heatmap.}
\usage{
vis.heatmap(.data, .title = "Number of shared clonotypes",
  .labs = c("Sample", "Sample"), .legend = "Shared clonotypes",
  .na.value = NA, .text = T)
}
\arguments{
\item{.data}{Either a matrix with colnames and rownames specifyed or a data.frame with the first column of
strings for row names and other columns stands for values.}

\item{.title}{Main title of the plot.}

\item{.labs}{Labs names. Character vector of length 2 (for naming x-axis and y-axis).}

\item{.legend}{Title for the legend.}

\item{.na.value}{Replace NAs with this values.}

\item{.text}{if T then print \code{.data} values at tiles.}
}
\value{
ggplot object.
}
\description{
Plot a heatmap from a matrix or a data.frame
}
\examples{
\dontrun{
# Load your data.
load('immdata.rda')
# Perform cloneset overlap by amino acid sequences with V-segments.
imm.av <- repOverlap(immdata, .seq = 'aa', .vgene = T)
# Plot a heatmap.
vis.heatmap(imm.av, .title = 'Immdata - (ave)-intersection')
}
}

