% Generated by roxygen2 (4.0.2): do not edit by hand
\name{get.deletions.alpha}
\alias{get.deletions.alpha}
\alias{get.deletions.beta}
\title{Compute the number of deletions in MiTCR data frames.}
\usage{
get.deletions.alpha(.data, .Vs = segments$TRAV, .Js = segments$TRAJ)

get.deletions.beta(.data, .Vs = segments$TRBV, .Js = segments$TRBJ, .Ds = segments$TRBD)
}
\arguments{
\item{.data}{Mitcr data.frame.}

\item{.Vs}{Table of V segments; must have 'V.segment' and 'Nucleotide.sequence' columns.}

\item{.Js}{Table of J segments; must have 'J.segment' and 'Nucleotide.sequence' columns.}

\item{.Ds}{Table of D segments; must have 'D.segment' and 'Nucleotide.sequence' columns.}
}
\value{
Mitcr data.frame with 3 (for alpha chains) or 5 (for beta chains) new columns for deletions.
}
\description{
Get deletions for VD, DJ, 5'D and 3'D ends and two columns with
total deletions for VD/DJ and 5'D/3'D deletions for the given mitcr data.frame
with 0-indexes columns. Cases, in which deletions cannot be determined, will have -1
in their cell.
}
\details{
By default, \code{*.table} parameters are taken from the \code{segments} data frame which
can be loaded to your R environment with data(segments). Data for segments has been taken from IMGT.
}
\examples{
\dontrun{
data(segments)
immdata <- get.deletions.beta(.data)
immdata.prob <- tcr.prob.df(immdata)
}
}

