% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tbr_median.R
\name{tbr_median}
\alias{tbr_median}
\title{Time-Based Rolling Median}
\usage{
tbr_median(.tbl, x, tcolumn, unit = "years", n, ...)
}
\arguments{
\item{.tbl}{a data frame with at least two variables; time column formatted as date, date/time and value column.}

\item{x}{column containing the numeric values to calculate the mean.}

\item{tcolumn}{formatted time column.}

\item{unit}{character, one of "years", "months", "weeks", "days", "hours", "minutes", "seconds"}

\item{n}{numeric, describing the length of the time window.}

\item{...}{additional arguments passed to \code{\link{median_ci}}}
}
\value{
tibble with columns for the rolling median and upper and lower confidence intervals.
}
\description{
Produces a a rolling time-window based vector of medians and confidence intervals.
}
\examples{
## Return a tibble with new rolling median column
tbr_median(Dissolved_Oxygen, x = Average_DO, tcolumn = Date, unit = "years",
n = 5)

\dontrun{
## Return a tibble with rolling median and 95\% CI 
tbr_median(Dissolved_Oxygen, x = Average_DO, tcolumn = Date, unit = "years", n = 5, conf = .95)}
}
\seealso{
\code{\link{median_ci}}
}
