% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tar_load.R
\name{tar_load}
\alias{tar_load}
\title{Load the values of targets.}
\usage{
tar_load(
  names,
  branches = NULL,
  meta = tar_meta(targets_only = TRUE, store = store),
  strict = TRUE,
  silent = FALSE,
  envir = parent.frame(),
  store = targets::tar_config_get("store")
)
}
\arguments{
\item{names}{Names of the targets to load.
You may supply \code{tidyselect} helpers like \code{\link[=any_of]{any_of()}} and \code{\link[=starts_with]{starts_with()}}.
Names are selected from the metadata in \verb{_targets/meta},
which may include errored targets.}

\item{branches}{Integer of indices of the branches to load
for any targets that are patterns.}

\item{meta}{Data frame of metadata from \code{\link[=tar_meta]{tar_meta()}}.
\code{tar_read()} with the default arguments can be inefficient for large
pipelines because all the metadata is stored in a single file.
However, if you call \code{\link[=tar_meta]{tar_meta()}} beforehand and supply it to the \code{meta}
argument, then successive calls to \code{tar_read()} may run much faster.}

\item{strict}{Logical of length 1, whether to error out
if one of the selected targets is in the metadata
but cannot be loaded.
Set to \code{FALSE} to just load the targets in the metadata
that can be loaded and skip the others.}

\item{silent}{Logical of length 1. Only relevant when
\code{strict} is \code{FALSE}. If \code{silent} is \code{FALSE}
and \code{strict} is \code{FALSE}, then a message will be printed
if a target is in the metadata but cannot be loaded.
However, load failures
will not stop other targets from being loaded.}

\item{envir}{Environment to put the loaded targets.}

\item{store}{Character of length 1, path to the
\code{targets} data store. Defaults to \code{tar_config_get("store")},
which in turn defaults to \verb{_targets/}.
When you set this argument, the value of \code{tar_config_get("store")}
is temporarily changed for the current function call.
See \code{\link[=tar_config_get]{tar_config_get()}} and \code{\link[=tar_config_set]{tar_config_set()}} for details
about how to set the data store path persistently
for a project.}
}
\value{
Nothing.
}
\description{
Load the return values of targets into the current environment
(or the environment of your choosing). For a typical target, the return
value lives in a file in \verb{_targets/objects/}. For dynamic files (i.e.
\code{format = "file"}) the paths loaded in place of the values.
\code{\link[=tar_load_everything]{tar_load_everything()}} is shorthand for \code{tar_load(everything())}
to load all targets.
}
\section{Limited scope}{

\code{tar_read()} and \code{tar_load()}
are only for exploratory analysis and literate programming,
and \code{tar_read_raw()} and \code{tar_load_raw()} are only
for exploratory analysis. \code{targets} automatically
loads the correct dependencies into memory when the pipeline
is running, so invoking these functions
from inside a target is rarely advisable.
}

\examples{
if (identical(Sys.getenv("TAR_EXAMPLES"), "true")) { # for CRAN
tar_dir({ # tar_dir() runs code from a temp dir for CRAN.
tar_script({
  list(
    tar_target(y1, 1 + 1),
    tar_target(y2, 1 + 1),
    tar_target(z, y1 + y2)
  )
}, ask = FALSE)
tar_make()
ls() # Does not have "y1", "y2", or "z".
tar_load(starts_with("y"))
ls() # Has "y1" and "y2" but not "z".
tar_load(any_of("z"))
ls() # Has "y1", "y2", and "z".
})
}
}
\seealso{
Other data: 
\code{\link{tar_crew}()},
\code{\link{tar_load_everything}()},
\code{\link{tar_load_raw}()},
\code{\link{tar_meta}()},
\code{\link{tar_objects}()},
\code{\link{tar_pid}()},
\code{\link{tar_process}()},
\code{\link{tar_read_raw}()},
\code{\link{tar_read}()}
}
\concept{data}
