% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/render-rmd.R, R/render-summary.R
\name{rmd.table_builder}
\alias{rmd.table_builder}
\alias{summary.tangram}
\alias{summary.table_builder}
\alias{summary.cell}
\alias{summary.cell_label}
\alias{summary.cell_iqr}
\alias{summary.cell_range}
\alias{summary.cell_estimate}
\alias{summary.cell_fraction}
\alias{summary.cell_fstat}
\alias{summary.cell_chi2}
\title{The default method for rendering tangram objects
A tangram is a summary, so it returns itself. Otherwise convert to a text representation.}
\usage{
\method{rmd}{table_builder}(object, ...)

\method{summary}{tangram}(object, ...)

\method{summary}{table_builder}(object, ...)

\method{summary}{cell}(object, ...)

\method{summary}{cell_label}(object, ...)

\method{summary}{cell_iqr}(object, ...)

\method{summary}{cell_range}(object, ...)

\method{summary}{cell_estimate}(object, ...)

\method{summary}{cell_fraction}(object, ...)

\method{summary}{cell_fstat}(object, ...)

\method{summary}{cell_chi2}(object, ...)
}
\arguments{
\item{object}{object; the item to render}

\item{...}{additional arguments passed to summary}
}
\value{
the text summary
}
\description{
The default method for rendering tangram objects
A tangram is a summary, so it returns itself. Otherwise convert to a text representation.
}
\examples{
summary(cell_label("123"))
summary(cell_iqr(rnorm(20)))
summary(cell_estimate(2.1,0.8, 3.3))
summary(cell_fraction(45, 137))
summary(table_builder()   \%>\%
        row_header("row") \%>\%
        col_header(1,2,3) \%>\%
        add_col("A","B","C"))
summary(tangram(drug~bili, pbc))
}
