% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/transform-hmisc.R
\name{summarize_kruskal_horz}
\alias{summarize_kruskal_horz}
\title{Create a summarization for a categorical set of column versus a numerical row}
\usage{
summarize_kruskal_horz(table, row, column, pformat = NULL, msd = FALSE,
  quant = c(0.25, 0.5, 0.75), overall = NULL, ...)
}
\arguments{
\item{table}{The table object to modify}

\item{row}{The row variable object to use (numerical)}

\item{column}{The column variable to use (categorical)}

\item{pformat}{numeric or character; A formatting directive to be applied to p-values}

\item{msd}{logical; Include mean and standard deviation with quantile statistics}

\item{quant}{numeric; Vector of quantiles to include. Should be an odd number since the middle value is highlighted on display.}

\item{overall}{logical; Include overall summary statistics for a categorical column}

\item{...}{absorbs additional arugments. Unused at present.}
}
\value{
The modified table object
}
\description{
Given a row and column object from the parser apply a Kruskal test and output
the results horizontally. 1 X (n + no. categories + test statistic)
}
