/*
 * Decompiled with CFR 0.152.
 */
package main;

import beagleutil.Samples;
import blbutil.BGZIPOutputStream;
import blbutil.FileUtil;
import blbutil.IntPair;
import blbutil.Utilities;
import ibd.IbdSegment;
import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.text.DecimalFormat;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import main.AlleleProbs;
import main.CurrentData;
import main.GenotypeValues;
import vcf.VcfWriter;

public class WindowWriter
implements Closeable {
    private static final DecimalFormat df2 = new DecimalFormat("#.##");
    private boolean appendIbd = false;
    private final Samples samples;
    private final String outPrefix;
    private final File vcfOutFile;
    private final File ibdOutFile;
    private final File hbdOutFile;
    private final Map<IntPair, IbdSegment> ibdBuffer = new HashMap<IntPair, IbdSegment>();

    public WindowWriter(Samples samples, String string) {
        if (samples == null) {
            throw new NullPointerException("samples==null");
        }
        if (string.length() == 0) {
            throw new IllegalArgumentException("outPrefix.length()==0");
        }
        this.samples = samples;
        this.outPrefix = string;
        this.vcfOutFile = new File(string + ".vcf.gz");
        this.ibdOutFile = new File(string + ".ibd.gz");
        this.hbdOutFile = new File(string + ".hbd.gz");
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        try (PrintWriter printWriter = new PrintWriter(new BGZIPOutputStream(byteArrayOutputStream, false));){
            boolean bl = true;
            boolean bl2 = true;
            boolean bl3 = false;
            VcfWriter.writeMetaLines(samples.ids(), "beagle.21Jan17.6cc.jar (version 4.1)", bl, bl2, bl3, printWriter);
        }
        boolean bl = false;
        WindowWriter.writeBytesToFile(byteArrayOutputStream.toByteArray(), this.vcfOutFile, bl);
    }

    public String outPrefix() {
        return this.outPrefix;
    }

    private static void write(byte[] byArray, OutputStream outputStream) {
        try {
            outputStream.write(byArray);
        }
        catch (IOException iOException) {
            Utilities.exit("Error writing byte", iOException);
        }
    }

    private static void writeBytesToFile(byte[] byArray, File file, boolean bl) {
        try (FileOutputStream fileOutputStream = new FileOutputStream(file, bl);){
            fileOutputStream.write(byArray);
        }
        catch (IOException iOException) {
            Utilities.exit("Error writing to file: " + file, iOException);
        }
    }

    public Samples samples() {
        return this.samples;
    }

    public void printGV(CurrentData currentData, GenotypeValues genotypeValues) {
        boolean bl = true;
        try (PrintWriter printWriter = FileUtil.bgzipPrintWriter(this.vcfOutFile, bl);){
            VcfWriter.appendRecords(genotypeValues, currentData.prevTargetSpliceStart(), currentData.nextTargetSpliceStart(), printWriter);
        }
    }

    public void print(AlleleProbs alleleProbs, boolean[] blArray, int n, int n2, boolean bl, boolean bl2, int n3) {
        int n4 = WindowWriter.nMarkersPerStep(alleleProbs.nSamples(), bl, bl2);
        int n5 = WindowWriter.nSteps(n2 - n, n4);
        AtomicInteger atomicInteger = new AtomicInteger(0);
        ConcurrentHashMap<Integer, byte[]> concurrentHashMap = new ConcurrentHashMap<Integer, byte[]>();
        ExecutorService executorService = Executors.newFixedThreadPool(n3);
        for (int i = 0; i < n3; ++i) {
            executorService.submit(() -> {
                try {
                    int n5 = atomicInteger.getAndIncrement();
                    while (n5 < n5) {
                        int n6 = n + n4 * n5;
                        int n7 = Math.min(n6 + n4, n2);
                        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                        try (PrintWriter printWriter = new PrintWriter(new BGZIPOutputStream(byteArrayOutputStream, false));){
                            VcfWriter.appendRecords(alleleProbs, blArray, n6, n7, bl, bl2, printWriter);
                        }
                        concurrentHashMap.put(n5, byteArrayOutputStream.toByteArray());
                        n5 = atomicInteger.getAndIncrement();
                    }
                }
                catch (Exception exception) {
                    Utilities.exit("", exception);
                }
            });
        }
        try {
            executorService.shutdown();
            executorService.awaitTermination(Long.MAX_VALUE, TimeUnit.DAYS);
        }
        catch (Throwable throwable) {
            Utilities.exit("ERROR", throwable);
        }
        WindowWriter.print(concurrentHashMap, this.vcfOutFile);
    }

    private static void print(ConcurrentHashMap<Integer, byte[]> concurrentHashMap, File file) {
        boolean bl = true;
        int n = 0;
        try (BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(new FileOutputStream(file, bl));){
            byte[] byArray = concurrentHashMap.get(n++);
            while (byArray != null) {
                WindowWriter.write(byArray, bufferedOutputStream);
                byArray = concurrentHashMap.get(n++);
            }
        }
        catch (IOException iOException) {
            Utilities.exit("Error writing to file: " + file, iOException);
        }
    }

    private static int nMarkersPerStep(int n, boolean bl, boolean bl2) {
        int n2 = 0x320000;
        int n3 = 4;
        if (bl) {
            n3 += 2;
        }
        if (bl2) {
            n3 += 6;
        }
        return n2 / (n * n3);
    }

    private static int nSteps(int n, int n2) {
        int n3 = n / n2;
        if (n3 * n2 != n) {
            ++n3;
        }
        return n3;
    }

    public void printIbd(CurrentData currentData, Map<IntPair, List<IbdSegment>> map) {
        if (!this.samples.equals(currentData.targetSamples())) {
            throw new IllegalArgumentException("inconsistent samples");
        }
        this.printIbd(map, currentData.prevTargetSpliceStart(), currentData.nextTargetOverlapStart(), currentData.nextTargetSpliceStart(), currentData.nTargetMarkers());
        if (!this.appendIbd) {
            this.appendIbd = true;
        }
    }

    private void printIbd(Map<IntPair, List<IbdSegment>> map, int n, int n2, int n3, int n4) {
        HashMap<IntPair, IbdSegment> hashMap = new HashMap<IntPair, IbdSegment>(this.ibdBuffer);
        this.ibdBuffer.clear();
        try (PrintWriter printWriter = FileUtil.bgzipPrintWriter(this.ibdOutFile, this.appendIbd);
             PrintWriter printWriter2 = FileUtil.bgzipPrintWriter(this.hbdOutFile, this.appendIbd);){
            Iterator<IntPair> iterator = map.keySet().iterator();
            while (iterator.hasNext()) {
                IntPair intPair = iterator.next();
                List<IbdSegment> list = map.get(intPair);
                for (IbdSegment ibdSegment : list) {
                    int n5;
                    IbdSegment ibdSegment2;
                    if (ibdSegment.startIndex() == 0 && (ibdSegment2 = (IbdSegment)hashMap.get(intPair)) != null) {
                        ibdSegment = WindowWriter.merge(ibdSegment2, ibdSegment);
                    }
                    if ((n5 = ibdSegment.endIndex() + 1) >= n && (n3 == n4 || n5 < n3)) {
                        WindowWriter.printSegment(this.samples, ibdSegment, printWriter, printWriter2);
                        continue;
                    }
                    if (ibdSegment.startIndex() >= n2) continue;
                    this.ibdBuffer.put(intPair, ibdSegment);
                }
                iterator.remove();
            }
        }
    }

    private static IbdSegment merge(IbdSegment ibdSegment, IbdSegment ibdSegment2) {
        assert (ibdSegment.hapPair().equals(ibdSegment2.hapPair()));
        assert (ibdSegment.start().chromIndex() == ibdSegment2.start().chromIndex());
        int n = -1;
        float f = Math.max(ibdSegment.score(), ibdSegment2.score());
        return new IbdSegment(ibdSegment.hapPair(), ibdSegment.start(), ibdSegment2.end(), f, n, ibdSegment2.endIndex());
    }

    private static void printSegment(Samples samples, IbdSegment ibdSegment, PrintWriter printWriter, PrintWriter printWriter2) {
        int n;
        int n2;
        int n3 = ibdSegment.hap1();
        int n4 = n3 / 2;
        PrintWriter printWriter3 = n4 == (n2 = (n = ibdSegment.hap2()) / 2) ? printWriter2 : printWriter;
        printWriter3.print(samples.id(n4));
        printWriter3.print('\t');
        printWriter3.print(n3 % 2 + 1);
        printWriter3.print('\t');
        printWriter3.print(samples.id(n2));
        printWriter3.print('\t');
        printWriter3.print(n % 2 + 1);
        printWriter3.print('\t');
        printWriter3.print(ibdSegment.start().chrom());
        printWriter3.print('\t');
        printWriter3.print(ibdSegment.start().pos());
        printWriter3.print('\t');
        printWriter3.print(ibdSegment.end().pos());
        printWriter3.print('\t');
        printWriter3.println(df2.format(ibdSegment.score()));
    }

    @Override
    public void close() {
        boolean bl = true;
        try (FileOutputStream fileOutputStream = new FileOutputStream(this.vcfOutFile, bl);
             BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(fileOutputStream);){
            BGZIPOutputStream bGZIPOutputStream = new BGZIPOutputStream(bufferedOutputStream, true);
            Throwable throwable = null;
            if (bGZIPOutputStream != null) {
                if (throwable != null) {
                    try {
                        bGZIPOutputStream.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                } else {
                    bGZIPOutputStream.close();
                }
            }
        }
        catch (IOException iOException) {
            Utilities.exit("Error closing file: " + this.vcfOutFile, iOException);
        }
    }
}

