/*
 * Decompiled with CFR 0.152.
 */
package main;

import beagleutil.Samples;
import main.GenotypeValues;
import vcf.Marker;
import vcf.Markers;

public class RevGenotypeValues
implements GenotypeValues {
    private final GenotypeValues gvi;

    public RevGenotypeValues(GenotypeValues genotypeValues) {
        this.gvi = genotypeValues;
    }

    @Override
    public float value(int n, int n2, int n3) {
        int n4 = this.gvi.nMarkers() - 1 - n;
        return this.gvi.value(n4, n2, n3);
    }

    @Override
    public void add(int n, double[] dArray) {
        if (dArray.length != this.gvi.markers().sumGenotypes()) {
            throw new IllegalArgumentException("values.length=" + dArray.length);
        }
        int n2 = 0;
        int n3 = this.gvi.nMarkers();
        for (int i = 0; i < n3; ++i) {
            int n4 = this.gvi.nMarkers() - 1 - i;
            int n5 = this.gvi.marker(n4).nGenotypes();
            for (int j = 0; j < n5; ++j) {
                this.gvi.add(n4, n, j, dArray[n2++]);
            }
        }
    }

    @Override
    public void add(int n, int n2, int n3, double d) {
        int n4 = this.gvi.nMarkers() - 1 - n;
        this.gvi.add(n4, n2, n3, d);
    }

    @Override
    public Samples samples() {
        return this.gvi.samples();
    }

    @Override
    public int nSamples() {
        return this.gvi.nSamples();
    }

    @Override
    public Marker marker(int n) {
        return this.gvi.markers().reverse().marker(n);
    }

    @Override
    public Markers markers() {
        return this.gvi.markers().reverse();
    }

    @Override
    public int nMarkers() {
        return this.gvi.nMarkers();
    }
}

