\name{svyPVglm}
\alias{svyPVglm}
\alias{summary.svyPVglm}

\title{
Survey-weighted generalised linear models with uasge of palusible values. 
}
\description{
Fit a generalised linear model to data from a complex survey design with usage of plausible values.
}
\usage{
svyPVglm(formula, design, placeholder = 1:10, family = gaussian())
\method{summary}{svyPVglm}(object, \dots)
}

\arguments{
  \item{formula}{a model formula  (all variables have to be part of a survey design objecct created by the survey package). For a notation description for the plausible values see in 'details'.

}
  \item{design}{a survey design which was generated by the \code{survey} package

}
  \item{placeholder}{a vector of symbols, which were used for numbering the plausible values. For a detailed description see in 'details'.

}
  \item{family}{a description of the error distribution and link function to be used in the model.This has to be either a character string naming a family function, a family function or the result of a call to a family function.
}

  \item{object}{A object of class svyPVglm.

}

  \item{\dots}{

}

}
\details{All variables mentioned in the formula object must be part of the survey design object.  Instead of the symbols, which were used for numbering the plausible values use '..' as notation (e.g. placeholder = 1:5 and PVLIT.. stands for PVLIT1, PVLIT2, PVLIT3, PVLIT4, PVLIT5). Missing values are deleted listwise.

}
\value{The function returns a list, which includes the following dataframes. 

\item{coef}{Shows the regression coefficients and test statistics.}
\item{mod.fit}{Shows the model test statistic. For more details see \link{svyglm}.}
}
\references{Lumley, T. (2010). \emph{Complex Surveys}. Hoboken, NJ: Wiley.

Saerndal, C.-E. & Swensson, B. & Wretman, J. (1992). \emph{Model Assisted Survey Sampling}. New York: Springer.

Chaudhuri, A. & Stenger, H. (2005). \emph{Survey Sampling. Theory and Methods}. Boka Raton, FL: Chapman & Hall/CRC.
}
\author{
Jakob Peterbauer
}



\seealso{
\code{\link{svyglm}},
\code{\link{svyPVcor}},
\code{\link{svyPVeta}}
}
\examples{
data(svy_example1)

res_glm <- svyPVglm(plaus.. ~ otherPlaus.. + age, svy.exrep, placeholder = 1:3)

res_glm

}
% Add one or more standard keywords, see file 'KEYWORDS' in the
% R documentation directory.
\keyword{glm}




