\name{svyPVcor}
\alias{svyPVcor}


\title{
Survey-weighted Correlation Estimation with uasge of palusible values. 
}
\description{
svyPVcor estimates the Pearson product-moment correlation coefficient and its standard error for data from a complex survey design with plausible values. 

}
\usage{
svyPVcor(formula, design, placeholder = 1:10)
}
%- maybe also 'usage' for other objects documented here.
\arguments{
  \item{formula}{Formula, x~y for the correlation between x and y (both variables have to be part of a survey design objecct created by the \code{survey} package). For a notation description for the plausible values see in 'details'. 

}
  \item{design}{A survey design which was generated by the \code{survey} package
.
}
  \item{placeholder}{A vector of symbols, which were used for numbering of the plausible values. For a detailed description see in 'details'.
}
}
\details{All variables mentioned in the formula object must be part of the survey design object. Instead of the symbols, which were used for numbering the plausible values use '..' as notation (e.g. placeholder = 1:5 and PVLIT.. stands for PVLIT1, PVLIT2, PVLIT3, PVLIT4, PVLIT5).Missing values are deleted listwise.
}

\value{
The function returns a data.frame with the following columns
\item{COR}{Shows the Pearson product-moment correlation coefficient between x and y.}
\item{SE}{Shows the SE for the Pearson product-moment correlation between x and y.}
\item{Number.of.cases}{Shows the unweighted number of cases (NA's excluded) within each group.}
\item{Sum.of.weights}{Shows the sum of weights (NA's excluded) within each group.}
}


\references{
Lumley, T. (2010). \emph{Complex Surveys}. Hoboken, NJ: Wiley.

Saerndal, C.-E. & Swensson, B. & Wretman, J. (1992). \emph{Model Assisted Survey Sampling}. New York: Springer.

Chaudhuri, A. & Stenger, H. (2005). \emph{Survey Sampling. Theory and Methods}. Boka Raton, FL: Chapman & Hall/CRC.
}


\author{
Jakob Peterbauer
}


%% ~Make other sections like Warning with \section{Warning }{....} ~

\seealso{
\code{\link{cov.wt}},
\code{\link{svyPVeta}}
}
\examples{
# data(svy_example1)
}
% Add one or more standard keywords, see file 'KEYWORDS' in the
% R documentation directory.
\keyword{correlation}

