% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/akritas.R
\name{predict.akritas}
\alias{predict.akritas}
\title{Predict method for Akritas Estimator}
\usage{
\method{predict}{akritas}(
  object,
  newdata,
  times = NULL,
  lambda = 0.5,
  type = c("survival", "risk", "all"),
  distr6 = FALSE,
  ...
)
}
\arguments{
\item{object}{(\code{akritas(1)})\cr
Object of class inheriting from \code{"akritas"}.}

\item{newdata}{\code{(data.frame(1))}\cr
Testing data of \code{data.frame} like object, internally is coerced with \code{\link[stats:model.matrix]{stats::model.matrix()}}.
If missing then training data from fitted object is used.}

\item{times}{\code{(numeric())}\cr
Times at which to evaluate the estimator. If \code{NULL} (default) then evaluated at all unique times
in the training set.}

\item{lambda}{(\code{numeric(1)})\cr
Bandwidth parameter for uniform smoothing kernel in nearest neighbours estimation.
The default value of \code{0.5} is arbitrary and should be chosen by the user.}

\item{type}{(\code{character(1)})\cr
Type of predicted value. Choices are survival probabilities over all time-points in training
data (\code{"survival"}) or a relative risk ranking (\code{"risk"}), which is the negative mean survival
time so higher rank implies higher risk of event, or both (\code{"all"}).}

\item{distr6}{(\code{logical(1)})\cr
If \code{FALSE} (default) and \code{type} is \code{"survival"} or \code{"all"} returns matrix of survival
probabilities, otherwise returns a \code{\link[distr6:VectorDistribution]{distr6::VectorDistribution()}}.}

\item{...}{\code{ANY} \cr
Currently ignored.}
}
\value{
A \code{numeric} if \code{type = "risk"}, a \code{\link[distr6:VectorDistribution]{distr6::VectorDistribution()}} (if \code{distr6 = TRUE})
and \code{type = "survival"}; a \code{matrix} if (\code{distr6 = FALSE}) and \code{type = "survival"} where
entries are survival probabilities with rows of observations and columns are time-points;
or a list combining above if \code{type = "all"}.
}
\description{
Predicted values from a fitted Akritas estimator.
}
\details{
This implementation uses a fit/predict interface to allow estimation on unseen data after
fitting on training data. This is achieved by fitting the empirical CDF on the training data
and applying this to the new data.
}
\examples{
if (requireNamespaces(c("distr6", "survival"))) {

library(survival)

train <- 1:10
test <- 11:20
fit <- akritas(Surv(time, status) ~ ., data = rats[train, ])
predict(fit, newdata = rats[test, ])

# when lambda = 1, identical to Kaplan-Meier
fit <- akritas(Surv(time, status) ~ ., data = rats[1:100, ])
predict_akritas <- predict(fit, newdata = rats[1:100, ], lambda = 1)[1, ]
predict_km <- survfit(Surv(time, status) ~ 1, data = rats[1:100, ])$surv
all(predict_akritas == predict_km)

# Use distr6 = TRUE to return a distribution
predict_distr <- predict(fit, newdata = rats[test, ], distr6 = TRUE)
predict_distr$survival(100)

# Return a relative risk ranking with type = "risk"
predict(fit, newdata = rats[test, ], type = "risk")

# Or survival probabilities and a rank
predict(fit, newdata = rats[test, ], type = "all", distr6 = TRUE)
}
}
\references{
Akritas, M. G. (1994).
Nearest Neighbor Estimation of a Bivariate Distribution Under Random Censoring.
Ann. Statist., 22(3), 1299–1327.
\doi{10.1214/aos/1176325630}
}
