% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/locate.R
\name{str_locate_nth}
\alias{str_locate_nth}
\alias{str_locate_first}
\alias{str_locate_last}
\title{Locate the indices of the \eqn{n}th instance of a pattern.}
\usage{
str_locate_nth(string, pattern, n)

str_locate_first(string, pattern)

str_locate_last(string, pattern)
}
\arguments{
\item{string}{A character vector. These functions are vectorized over this
argument.}

\item{pattern}{A character vector. Pattern(s) specified like the pattern(s)
in the stringr package (e.g. look at \code{\link[stringr:str_locate]{stringr::str_locate()}}). If
this has length >1 its length must be the same as that of \code{string}.}

\item{n}{Then \eqn{n} for the \eqn{n}th instance of the pattern.}
}
\value{
A two-column matrix. The \eqn{i}th row of this matrix gives the start
and end indices of the \eqn{n}th instance of \code{pattern} in the \eqn{i}th
element of \code{string}.
}
\description{
The \eqn{n}th instance of an pattern will cover a series of character
indices. These functions tell you which indices those are.
}
\details{
\itemize{ \item \code{str_locate_first(...)} is just
\code{str_locate_nth(..., n = 1)}. \item
\code{str_locate_last(...)} is just \code{str_locate_nth(..., n = -1)}. }
}
\examples{
str_locate_nth(c("abcdabcxyz", "abcabc"), "abc", 2)

}
