/*
 * Decompiled with CFR 0.152.
 */
package moa.streams.filters;

import com.yahoo.labs.samoa.instances.Attribute;
import com.yahoo.labs.samoa.instances.DenseInstance;
import com.yahoo.labs.samoa.instances.Instance;
import com.yahoo.labs.samoa.instances.InstanceImpl;
import com.yahoo.labs.samoa.instances.Instances;
import com.yahoo.labs.samoa.instances.InstancesHeader;
import com.yahoo.labs.samoa.instances.SparseInstance;
import java.util.ArrayList;
import java.util.List;
import moa.core.FastVector;
import moa.core.InstanceExample;
import moa.streams.InstanceStream;
import moa.streams.filters.AbstractStreamFilter;

public class RemoveDiscreteAttributeFilter
extends AbstractStreamFilter {
    private static final long serialVersionUID = 1L;
    protected InstancesHeader streamHeader;
    protected List<Integer> numericAttributes;

    @Override
    public String getPurposeString() {
        return "Removes discrete attribute examples in a stream.";
    }

    @Override
    protected void restartImpl() {
        this.streamHeader = null;
    }

    @Override
    public InstancesHeader getHeader() {
        return this.streamHeader;
    }

    @Override
    public InstanceExample nextInstance() {
        int i;
        Instance inst = (Instance)this.inputStream.nextInstance().getData();
        if (this.streamHeader == null) {
            FastVector<Attribute> attributes = new FastVector<Attribute>();
            this.numericAttributes = new ArrayList<Integer>();
            for (i = 0; i < inst.numAttributes(); ++i) {
                if (!inst.attribute(i).isNumeric()) continue;
                this.numericAttributes.add(i);
                attributes.addElement(inst.attribute(i));
            }
            attributes.addElement(inst.classAttribute());
            this.numericAttributes.add(inst.classIndex());
            this.streamHeader = new InstancesHeader(new Instances(this.getCLICreationString(InstanceStream.class), attributes, 0));
            this.streamHeader.setClassIndex(this.streamHeader.numAttributes() - 1);
        }
        double[] vals = new double[this.getHeader().numAttributes()];
        for (i = 0; i < this.numericAttributes.size(); ++i) {
            vals[i] = inst.value(this.numericAttributes.get(i));
        }
        InstanceImpl instance = null;
        instance = inst instanceof SparseInstance ? new SparseInstance(inst.weight(), vals) : new DenseInstance(inst.weight(), vals);
        return new InstanceExample(instance);
    }

    @Override
    public void getDescription(StringBuilder sb, int indent) {
    }
}

