/*
 * Decompiled with CFR 0.152.
 */
package moa.classifiers.trees;

import com.github.javacliparser.FlagOption;
import com.github.javacliparser.FloatOption;
import com.github.javacliparser.IntOption;
import com.github.javacliparser.MultiChoiceOption;
import com.yahoo.labs.samoa.instances.Instance;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import moa.AbstractMOAObject;
import moa.capabilities.CapabilitiesHandler;
import moa.capabilities.Capability;
import moa.capabilities.ImmutableCapabilities;
import moa.classifiers.AbstractClassifier;
import moa.classifiers.MultiClassClassifier;
import moa.classifiers.bayes.NaiveBayes;
import moa.classifiers.core.AttributeSplitSuggestion;
import moa.classifiers.core.attributeclassobservers.AttributeClassObserver;
import moa.classifiers.core.attributeclassobservers.DiscreteAttributeClassObserver;
import moa.classifiers.core.attributeclassobservers.NullAttributeClassObserver;
import moa.classifiers.core.attributeclassobservers.NumericAttributeClassObserver;
import moa.classifiers.core.conditionaltests.InstanceConditionalTest;
import moa.classifiers.core.splitcriteria.SplitCriterion;
import moa.core.AutoExpandVector;
import moa.core.DoubleVector;
import moa.core.Measurement;
import moa.core.SizeOf;
import moa.core.StringUtils;
import moa.core.Utils;
import moa.options.ClassOption;

public class HoeffdingTree
extends AbstractClassifier
implements MultiClassClassifier,
CapabilitiesHandler {
    private static final long serialVersionUID = 1L;
    public IntOption maxByteSizeOption = new IntOption("maxByteSize", 'm', "Maximum memory consumed by the tree.", 0x2000000, 0, Integer.MAX_VALUE);
    public ClassOption numericEstimatorOption = new ClassOption("numericEstimator", 'n', "Numeric estimator to use.", NumericAttributeClassObserver.class, "GaussianNumericAttributeClassObserver");
    public ClassOption nominalEstimatorOption = new ClassOption("nominalEstimator", 'd', "Nominal estimator to use.", DiscreteAttributeClassObserver.class, "NominalAttributeClassObserver");
    public IntOption memoryEstimatePeriodOption = new IntOption("memoryEstimatePeriod", 'e', "How many instances between memory consumption checks.", 1000000, 0, Integer.MAX_VALUE);
    public IntOption gracePeriodOption = new IntOption("gracePeriod", 'g', "The number of instances a leaf should observe between split attempts.", 200, 0, Integer.MAX_VALUE);
    public ClassOption splitCriterionOption = new ClassOption("splitCriterion", 's', "Split criterion to use.", SplitCriterion.class, "InfoGainSplitCriterion");
    public FloatOption splitConfidenceOption = new FloatOption("splitConfidence", 'c', "The allowable error in split decision, values closer to 0 will take longer to decide.", 1.0E-7, 0.0, 1.0);
    public FloatOption tieThresholdOption = new FloatOption("tieThreshold", 't', "Threshold below which a split will be forced to break ties.", 0.05, 0.0, 1.0);
    public FlagOption binarySplitsOption = new FlagOption("binarySplits", 'b', "Only allow binary splits.");
    public FlagOption stopMemManagementOption = new FlagOption("stopMemManagement", 'z', "Stop growing as soon as memory limit is hit.");
    public FlagOption removePoorAttsOption = new FlagOption("removePoorAtts", 'r', "Disable poor attributes.");
    public FlagOption noPrePruneOption = new FlagOption("noPrePrune", 'p', "Disable pre-pruning.");
    protected Node treeRoot;
    protected int decisionNodeCount;
    protected int activeLeafNodeCount;
    protected int inactiveLeafNodeCount;
    protected double inactiveLeafByteSizeEstimate;
    protected double activeLeafByteSizeEstimate;
    protected double byteSizeEstimateOverheadFraction;
    protected boolean growthAllowed;
    public MultiChoiceOption leafpredictionOption = new MultiChoiceOption("leafprediction", 'l', "Leaf prediction to use.", new String[]{"MC", "NB", "NBAdaptive"}, new String[]{"Majority class", "Naive Bayes", "Naive Bayes Adaptive"}, 2);
    public IntOption nbThresholdOption = new IntOption("nbThreshold", 'q', "The number of instances a leaf should observe before permitting Naive Bayes.", 0, 0, Integer.MAX_VALUE);

    @Override
    public String getPurposeString() {
        return "Hoeffding Tree or VFDT.";
    }

    public int calcByteSize() {
        int size = (int)SizeOf.sizeOf(this);
        if (this.treeRoot != null) {
            size += this.treeRoot.calcByteSizeIncludingSubtree();
        }
        return size;
    }

    @Override
    public int measureByteSize() {
        return this.calcByteSize();
    }

    @Override
    public void resetLearningImpl() {
        this.treeRoot = null;
        this.decisionNodeCount = 0;
        this.activeLeafNodeCount = 0;
        this.inactiveLeafNodeCount = 0;
        this.inactiveLeafByteSizeEstimate = 0.0;
        this.activeLeafByteSizeEstimate = 0.0;
        this.byteSizeEstimateOverheadFraction = 1.0;
        this.growthAllowed = true;
        if (this.leafpredictionOption.getChosenIndex() > 0) {
            this.removePoorAttsOption = null;
        }
    }

    @Override
    public void trainOnInstanceImpl(Instance inst) {
        if (this.treeRoot == null) {
            this.treeRoot = this.newLearningNode();
            this.activeLeafNodeCount = 1;
        }
        FoundNode foundNode = this.treeRoot.filterInstanceToLeaf(inst, null, -1);
        Node leafNode = foundNode.node;
        if (leafNode == null) {
            leafNode = this.newLearningNode();
            foundNode.parent.setChild(foundNode.parentBranch, leafNode);
            ++this.activeLeafNodeCount;
        }
        if (leafNode instanceof LearningNode) {
            ActiveLearningNode activeLearningNode;
            double weightSeen;
            LearningNode learningNode = (LearningNode)leafNode;
            learningNode.learnFromInstance(inst, this);
            if (this.growthAllowed && learningNode instanceof ActiveLearningNode && (weightSeen = (activeLearningNode = (ActiveLearningNode)learningNode).getWeightSeen()) - activeLearningNode.getWeightSeenAtLastSplitEvaluation() >= (double)this.gracePeriodOption.getValue()) {
                this.attemptToSplit(activeLearningNode, foundNode.parent, foundNode.parentBranch);
                activeLearningNode.setWeightSeenAtLastSplitEvaluation(weightSeen);
            }
        }
        if (this.trainingWeightSeenByModel % (double)this.memoryEstimatePeriodOption.getValue() == 0.0) {
            this.estimateModelByteSizes();
        }
    }

    @Override
    public double[] getVotesForInstance(Instance inst) {
        if (this.treeRoot != null) {
            FoundNode foundNode = this.treeRoot.filterInstanceToLeaf(inst, null, -1);
            Node leafNode = foundNode.node;
            if (leafNode == null) {
                leafNode = foundNode.parent;
            }
            return leafNode.getClassVotes(inst, this);
        }
        int numClasses = inst.dataset().numClasses();
        return new double[numClasses];
    }

    @Override
    protected Measurement[] getModelMeasurementsImpl() {
        return new Measurement[]{new Measurement("tree size (nodes)", this.decisionNodeCount + this.activeLeafNodeCount + this.inactiveLeafNodeCount), new Measurement("tree size (leaves)", this.activeLeafNodeCount + this.inactiveLeafNodeCount), new Measurement("active learning leaves", this.activeLeafNodeCount), new Measurement("tree depth", this.measureTreeDepth()), new Measurement("active leaf byte size estimate", this.activeLeafByteSizeEstimate), new Measurement("inactive leaf byte size estimate", this.inactiveLeafByteSizeEstimate), new Measurement("byte size estimate overhead", this.byteSizeEstimateOverheadFraction)};
    }

    public int measureTreeDepth() {
        if (this.treeRoot != null) {
            return this.treeRoot.subtreeDepth();
        }
        return 0;
    }

    @Override
    public void getModelDescription(StringBuilder out, int indent) {
        this.treeRoot.describeSubtree(this, out, indent);
    }

    @Override
    public boolean isRandomizable() {
        return false;
    }

    public static double computeHoeffdingBound(double range, double confidence, double n) {
        return Math.sqrt(range * range * Math.log(1.0 / confidence) / (2.0 * n));
    }

    protected SplitNode newSplitNode(InstanceConditionalTest splitTest, double[] classObservations, int size) {
        return new SplitNode(splitTest, classObservations, size);
    }

    protected SplitNode newSplitNode(InstanceConditionalTest splitTest, double[] classObservations) {
        return new SplitNode(splitTest, classObservations);
    }

    protected AttributeClassObserver newNominalClassObserver() {
        AttributeClassObserver nominalClassObserver = (AttributeClassObserver)this.getPreparedClassOption(this.nominalEstimatorOption);
        return (AttributeClassObserver)nominalClassObserver.copy();
    }

    protected AttributeClassObserver newNumericClassObserver() {
        AttributeClassObserver numericClassObserver = (AttributeClassObserver)this.getPreparedClassOption(this.numericEstimatorOption);
        return (AttributeClassObserver)numericClassObserver.copy();
    }

    protected void attemptToSplit(ActiveLearningNode node, SplitNode parent, int parentIndex) {
        if (!node.observedClassDistributionIsPure()) {
            SplitCriterion splitCriterion = (SplitCriterion)this.getPreparedClassOption(this.splitCriterionOption);
            Object[] bestSplitSuggestions = node.getBestSplitSuggestions(splitCriterion, this);
            Arrays.sort(bestSplitSuggestions);
            boolean shouldSplit = false;
            if (bestSplitSuggestions.length < 2) {
                shouldSplit = bestSplitSuggestions.length > 0;
            } else {
                double hoeffdingBound = HoeffdingTree.computeHoeffdingBound(splitCriterion.getRangeOfMerit(node.getObservedClassDistribution()), this.splitConfidenceOption.getValue(), node.getWeightSeen());
                Object bestSuggestion = bestSplitSuggestions[bestSplitSuggestions.length - 1];
                Object secondBestSuggestion = bestSplitSuggestions[bestSplitSuggestions.length - 2];
                if (((AttributeSplitSuggestion)bestSuggestion).merit - ((AttributeSplitSuggestion)secondBestSuggestion).merit > hoeffdingBound || hoeffdingBound < this.tieThresholdOption.getValue()) {
                    shouldSplit = true;
                }
                if (this.removePoorAttsOption != null && this.removePoorAttsOption.isSet()) {
                    int[] splitAtts;
                    int i;
                    HashSet<Integer> poorAtts = new HashSet<Integer>();
                    for (i = 0; i < bestSplitSuggestions.length; ++i) {
                        if (((AttributeSplitSuggestion)bestSplitSuggestions[i]).splitTest == null || (splitAtts = ((AttributeSplitSuggestion)bestSplitSuggestions[i]).splitTest.getAttsTestDependsOn()).length != 1 || !(((AttributeSplitSuggestion)bestSuggestion).merit - ((AttributeSplitSuggestion)bestSplitSuggestions[i]).merit > hoeffdingBound)) continue;
                        poorAtts.add(new Integer(splitAtts[0]));
                    }
                    for (i = 0; i < bestSplitSuggestions.length; ++i) {
                        if (((AttributeSplitSuggestion)bestSplitSuggestions[i]).splitTest == null || (splitAtts = ((AttributeSplitSuggestion)bestSplitSuggestions[i]).splitTest.getAttsTestDependsOn()).length != 1 || !(((AttributeSplitSuggestion)bestSuggestion).merit - ((AttributeSplitSuggestion)bestSplitSuggestions[i]).merit < hoeffdingBound)) continue;
                        poorAtts.remove(new Integer(splitAtts[0]));
                    }
                    Iterator iterator = poorAtts.iterator();
                    while (iterator.hasNext()) {
                        int poorAtt = (Integer)iterator.next();
                        node.disableAttribute(poorAtt);
                    }
                }
            }
            if (shouldSplit) {
                Object splitDecision = bestSplitSuggestions[bestSplitSuggestions.length - 1];
                if (((AttributeSplitSuggestion)splitDecision).splitTest == null) {
                    this.deactivateLearningNode(node, parent, parentIndex);
                } else {
                    SplitNode newSplit = this.newSplitNode(((AttributeSplitSuggestion)splitDecision).splitTest, node.getObservedClassDistribution(), ((AttributeSplitSuggestion)splitDecision).numSplits());
                    for (int i = 0; i < ((AttributeSplitSuggestion)splitDecision).numSplits(); ++i) {
                        LearningNode newChild = this.newLearningNode(((AttributeSplitSuggestion)splitDecision).resultingClassDistributionFromSplit(i));
                        newSplit.setChild(i, newChild);
                    }
                    --this.activeLeafNodeCount;
                    ++this.decisionNodeCount;
                    this.activeLeafNodeCount += ((AttributeSplitSuggestion)splitDecision).numSplits();
                    if (parent == null) {
                        this.treeRoot = newSplit;
                    } else {
                        parent.setChild(parentIndex, newSplit);
                    }
                }
                this.enforceTrackerLimit();
            }
        }
    }

    public void enforceTrackerLimit() {
        if (this.inactiveLeafNodeCount > 0 || ((double)this.activeLeafNodeCount * this.activeLeafByteSizeEstimate + (double)this.inactiveLeafNodeCount * this.inactiveLeafByteSizeEstimate) * this.byteSizeEstimateOverheadFraction > (double)this.maxByteSizeOption.getValue()) {
            int i;
            if (this.stopMemManagementOption.isSet()) {
                this.growthAllowed = false;
                return;
            }
            FoundNode[] learningNodes = this.findLearningNodes();
            Arrays.sort(learningNodes, new Comparator<FoundNode>(){

                @Override
                public int compare(FoundNode fn1, FoundNode fn2) {
                    return Double.compare(fn1.node.calculatePromise(), fn2.node.calculatePromise());
                }
            });
            int maxActive = 0;
            while (maxActive < learningNodes.length) {
                if (!(((double)(++maxActive) * this.activeLeafByteSizeEstimate + (double)(learningNodes.length - maxActive) * this.inactiveLeafByteSizeEstimate) * this.byteSizeEstimateOverheadFraction > (double)this.maxByteSizeOption.getValue())) continue;
                --maxActive;
                break;
            }
            int cutoff = learningNodes.length - maxActive;
            for (i = 0; i < cutoff; ++i) {
                if (!(learningNodes[i].node instanceof ActiveLearningNode)) continue;
                this.deactivateLearningNode((ActiveLearningNode)learningNodes[i].node, learningNodes[i].parent, learningNodes[i].parentBranch);
            }
            for (i = cutoff; i < learningNodes.length; ++i) {
                if (!(learningNodes[i].node instanceof InactiveLearningNode)) continue;
                this.activateLearningNode((InactiveLearningNode)learningNodes[i].node, learningNodes[i].parent, learningNodes[i].parentBranch);
            }
        }
    }

    public void estimateModelByteSizes() {
        FoundNode[] learningNodes = this.findLearningNodes();
        long totalActiveSize = 0L;
        long totalInactiveSize = 0L;
        for (FoundNode foundNode : learningNodes) {
            if (foundNode.node instanceof ActiveLearningNode) {
                totalActiveSize += SizeOf.fullSizeOf(foundNode.node);
                continue;
            }
            totalInactiveSize += SizeOf.fullSizeOf(foundNode.node);
        }
        if (totalActiveSize > 0L) {
            this.activeLeafByteSizeEstimate = (double)totalActiveSize / (double)this.activeLeafNodeCount;
        }
        if (totalInactiveSize > 0L) {
            this.inactiveLeafByteSizeEstimate = (double)totalInactiveSize / (double)this.inactiveLeafNodeCount;
        }
        int actualModelSize = this.measureByteSize();
        double estimatedModelSize = (double)this.activeLeafNodeCount * this.activeLeafByteSizeEstimate + (double)this.inactiveLeafNodeCount * this.inactiveLeafByteSizeEstimate;
        this.byteSizeEstimateOverheadFraction = (double)actualModelSize / estimatedModelSize;
        if (actualModelSize > this.maxByteSizeOption.getValue()) {
            this.enforceTrackerLimit();
        }
    }

    public void deactivateAllLeaves() {
        FoundNode[] learningNodes = this.findLearningNodes();
        for (int i = 0; i < learningNodes.length; ++i) {
            if (!(learningNodes[i].node instanceof ActiveLearningNode)) continue;
            this.deactivateLearningNode((ActiveLearningNode)learningNodes[i].node, learningNodes[i].parent, learningNodes[i].parentBranch);
        }
    }

    protected void deactivateLearningNode(ActiveLearningNode toDeactivate, SplitNode parent, int parentBranch) {
        InactiveLearningNode newLeaf = new InactiveLearningNode(toDeactivate.getObservedClassDistribution());
        if (parent == null) {
            this.treeRoot = newLeaf;
        } else {
            parent.setChild(parentBranch, newLeaf);
        }
        --this.activeLeafNodeCount;
        ++this.inactiveLeafNodeCount;
    }

    protected void activateLearningNode(InactiveLearningNode toActivate, SplitNode parent, int parentBranch) {
        LearningNode newLeaf = this.newLearningNode(toActivate.getObservedClassDistribution());
        if (parent == null) {
            this.treeRoot = newLeaf;
        } else {
            parent.setChild(parentBranch, newLeaf);
        }
        ++this.activeLeafNodeCount;
        --this.inactiveLeafNodeCount;
    }

    protected FoundNode[] findLearningNodes() {
        LinkedList<FoundNode> foundList = new LinkedList<FoundNode>();
        this.findLearningNodes(this.treeRoot, null, -1, foundList);
        return foundList.toArray(new FoundNode[foundList.size()]);
    }

    protected void findLearningNodes(Node node, SplitNode parent, int parentBranch, List<FoundNode> found) {
        if (node != null) {
            if (node instanceof LearningNode) {
                found.add(new FoundNode(node, parent, parentBranch));
            }
            if (node instanceof SplitNode) {
                SplitNode splitNode = (SplitNode)node;
                for (int i = 0; i < splitNode.numChildren(); ++i) {
                    this.findLearningNodes(splitNode.getChild(i), splitNode, i, found);
                }
            }
        }
    }

    protected LearningNode newLearningNode() {
        return this.newLearningNode(new double[0]);
    }

    protected LearningNode newLearningNode(double[] initialClassObservations) {
        int predictionOption = this.leafpredictionOption.getChosenIndex();
        ActiveLearningNode ret = predictionOption == 0 ? new ActiveLearningNode(initialClassObservations) : (predictionOption == 1 ? new LearningNodeNB(initialClassObservations) : new LearningNodeNBAdaptive(initialClassObservations));
        return ret;
    }

    @Override
    public ImmutableCapabilities defineImmutableCapabilities() {
        if (this.getClass() == HoeffdingTree.class) {
            return new ImmutableCapabilities(Capability.VIEW_STANDARD, Capability.VIEW_LITE);
        }
        return new ImmutableCapabilities(Capability.VIEW_STANDARD);
    }

    public static class LearningNodeNBAdaptive
    extends LearningNodeNB {
        private static final long serialVersionUID = 1L;
        protected double mcCorrectWeight = 0.0;
        protected double nbCorrectWeight = 0.0;

        public LearningNodeNBAdaptive(double[] initialClassObservations) {
            super(initialClassObservations);
        }

        @Override
        public void learnFromInstance(Instance inst, HoeffdingTree ht) {
            int trueClass = (int)inst.classValue();
            if (this.observedClassDistribution.maxIndex() == trueClass) {
                this.mcCorrectWeight += inst.weight();
            }
            if (Utils.maxIndex(NaiveBayes.doNaiveBayesPrediction(inst, this.observedClassDistribution, this.attributeObservers)) == trueClass) {
                this.nbCorrectWeight += inst.weight();
            }
            super.learnFromInstance(inst, ht);
        }

        @Override
        public double[] getClassVotes(Instance inst, HoeffdingTree ht) {
            if (this.mcCorrectWeight > this.nbCorrectWeight) {
                return this.observedClassDistribution.getArrayCopy();
            }
            return NaiveBayes.doNaiveBayesPrediction(inst, this.observedClassDistribution, this.attributeObservers);
        }
    }

    public static class LearningNodeNB
    extends ActiveLearningNode {
        private static final long serialVersionUID = 1L;

        public LearningNodeNB(double[] initialClassObservations) {
            super(initialClassObservations);
        }

        @Override
        public double[] getClassVotes(Instance inst, HoeffdingTree ht) {
            if (this.getWeightSeen() >= (double)ht.nbThresholdOption.getValue()) {
                return NaiveBayes.doNaiveBayesPrediction(inst, this.observedClassDistribution, this.attributeObservers);
            }
            return super.getClassVotes(inst, ht);
        }

        @Override
        public void disableAttribute(int attIndex) {
        }
    }

    public static class ActiveLearningNode
    extends LearningNode {
        private static final long serialVersionUID = 1L;
        protected double weightSeenAtLastSplitEvaluation;
        protected AutoExpandVector<AttributeClassObserver> attributeObservers = new AutoExpandVector();
        protected boolean isInitialized = false;

        public ActiveLearningNode(double[] initialClassObservations) {
            super(initialClassObservations);
            this.weightSeenAtLastSplitEvaluation = this.getWeightSeen();
        }

        @Override
        public int calcByteSize() {
            return super.calcByteSize() + (int)SizeOf.fullSizeOf(this.attributeObservers);
        }

        @Override
        public void learnFromInstance(Instance inst, HoeffdingTree ht) {
            if (!this.isInitialized) {
                this.attributeObservers = new AutoExpandVector(inst.numAttributes());
                this.isInitialized = true;
            }
            this.observedClassDistribution.addToValue((int)inst.classValue(), inst.weight());
            for (int i = 0; i < inst.numAttributes() - 1; ++i) {
                int instAttIndex = HoeffdingTree.modelAttIndexToInstanceAttIndex(i, inst);
                AttributeClassObserver obs = this.attributeObservers.get(i);
                if (obs == null) {
                    obs = inst.attribute(instAttIndex).isNominal() ? ht.newNominalClassObserver() : ht.newNumericClassObserver();
                    this.attributeObservers.set(i, obs);
                }
                obs.observeAttributeClass(inst.value(instAttIndex), (int)inst.classValue(), inst.weight());
            }
        }

        public double getWeightSeen() {
            return this.observedClassDistribution.sumOfValues();
        }

        public double getWeightSeenAtLastSplitEvaluation() {
            return this.weightSeenAtLastSplitEvaluation;
        }

        public void setWeightSeenAtLastSplitEvaluation(double weight) {
            this.weightSeenAtLastSplitEvaluation = weight;
        }

        public AttributeSplitSuggestion[] getBestSplitSuggestions(SplitCriterion criterion, HoeffdingTree ht) {
            LinkedList<AttributeSplitSuggestion> bestSuggestions = new LinkedList<AttributeSplitSuggestion>();
            double[] preSplitDist = this.observedClassDistribution.getArrayCopy();
            if (!ht.noPrePruneOption.isSet()) {
                bestSuggestions.add(new AttributeSplitSuggestion(null, new double[0][], criterion.getMeritOfSplit(preSplitDist, new double[][]{preSplitDist})));
            }
            for (int i = 0; i < this.attributeObservers.size(); ++i) {
                AttributeSplitSuggestion bestSuggestion;
                AttributeClassObserver obs = this.attributeObservers.get(i);
                if (obs == null || (bestSuggestion = obs.getBestEvaluatedSplitSuggestion(criterion, preSplitDist, i, ht.binarySplitsOption.isSet())) == null) continue;
                bestSuggestions.add(bestSuggestion);
            }
            return bestSuggestions.toArray(new AttributeSplitSuggestion[bestSuggestions.size()]);
        }

        public void disableAttribute(int attIndex) {
            this.attributeObservers.set(attIndex, new NullAttributeClassObserver());
        }
    }

    public static class InactiveLearningNode
    extends LearningNode {
        private static final long serialVersionUID = 1L;

        public InactiveLearningNode(double[] initialClassObservations) {
            super(initialClassObservations);
        }

        @Override
        public void learnFromInstance(Instance inst, HoeffdingTree ht) {
            this.observedClassDistribution.addToValue((int)inst.classValue(), inst.weight());
        }
    }

    public static abstract class LearningNode
    extends Node {
        private static final long serialVersionUID = 1L;

        public LearningNode(double[] initialClassObservations) {
            super(initialClassObservations);
        }

        public abstract void learnFromInstance(Instance var1, HoeffdingTree var2);
    }

    public static class SplitNode
    extends Node {
        private static final long serialVersionUID = 1L;
        protected InstanceConditionalTest splitTest;
        protected AutoExpandVector<Node> children;

        @Override
        public int calcByteSize() {
            return super.calcByteSize() + (int)(SizeOf.sizeOf(this.children) + SizeOf.fullSizeOf(this.splitTest));
        }

        @Override
        public int calcByteSizeIncludingSubtree() {
            int byteSize = this.calcByteSize();
            for (Node child : this.children) {
                if (child == null) continue;
                byteSize += child.calcByteSizeIncludingSubtree();
            }
            return byteSize;
        }

        public SplitNode(InstanceConditionalTest splitTest, double[] classObservations, int size) {
            super(classObservations);
            this.splitTest = splitTest;
            this.children = new AutoExpandVector(size);
        }

        public SplitNode(InstanceConditionalTest splitTest, double[] classObservations) {
            super(classObservations);
            this.splitTest = splitTest;
            this.children = new AutoExpandVector();
        }

        public int numChildren() {
            return this.children.size();
        }

        public void setChild(int index, Node child) {
            if (this.splitTest.maxBranches() >= 0 && index >= this.splitTest.maxBranches()) {
                throw new IndexOutOfBoundsException();
            }
            this.children.set(index, child);
        }

        public Node getChild(int index) {
            return this.children.get(index);
        }

        public int instanceChildIndex(Instance inst) {
            return this.splitTest.branchForInstance(inst);
        }

        @Override
        public boolean isLeaf() {
            return false;
        }

        @Override
        public FoundNode filterInstanceToLeaf(Instance inst, SplitNode parent, int parentBranch) {
            int childIndex = this.instanceChildIndex(inst);
            if (childIndex >= 0) {
                Node child = this.getChild(childIndex);
                if (child != null) {
                    return child.filterInstanceToLeaf(inst, this, childIndex);
                }
                return new FoundNode(null, this, childIndex);
            }
            return new FoundNode(this, parent, parentBranch);
        }

        @Override
        public void describeSubtree(HoeffdingTree ht, StringBuilder out, int indent) {
            for (int branch = 0; branch < this.numChildren(); ++branch) {
                Node child = this.getChild(branch);
                if (child == null) continue;
                StringUtils.appendIndented(out, indent, "if ");
                out.append(this.splitTest.describeConditionForBranch(branch, ht.getModelContext()));
                out.append(": ");
                StringUtils.appendNewline(out);
                child.describeSubtree(ht, out, indent + 2);
            }
        }

        @Override
        public int subtreeDepth() {
            int maxChildDepth = 0;
            for (Node child : this.children) {
                int depth;
                if (child == null || (depth = child.subtreeDepth()) <= maxChildDepth) continue;
                maxChildDepth = depth;
            }
            return maxChildDepth + 1;
        }
    }

    public static class Node
    extends AbstractMOAObject {
        private static final long serialVersionUID = 1L;
        protected DoubleVector observedClassDistribution;

        public Node(double[] classObservations) {
            this.observedClassDistribution = new DoubleVector(classObservations);
        }

        public int calcByteSize() {
            return (int)(SizeOf.sizeOf(this) + SizeOf.fullSizeOf(this.observedClassDistribution));
        }

        public int calcByteSizeIncludingSubtree() {
            return this.calcByteSize();
        }

        public boolean isLeaf() {
            return true;
        }

        public FoundNode filterInstanceToLeaf(Instance inst, SplitNode parent, int parentBranch) {
            return new FoundNode(this, parent, parentBranch);
        }

        public double[] getObservedClassDistribution() {
            return this.observedClassDistribution.getArrayCopy();
        }

        public double[] getClassVotes(Instance inst, HoeffdingTree ht) {
            return this.observedClassDistribution.getArrayCopy();
        }

        public boolean observedClassDistributionIsPure() {
            return this.observedClassDistribution.numNonZeroEntries() < 2;
        }

        public void describeSubtree(HoeffdingTree ht, StringBuilder out, int indent) {
            StringUtils.appendIndented(out, indent, "Leaf ");
            out.append(ht.getClassNameString());
            out.append(" = ");
            out.append(ht.getClassLabelString(this.observedClassDistribution.maxIndex()));
            out.append(" weights: ");
            this.observedClassDistribution.getSingleLineDescription(out, ht.treeRoot.observedClassDistribution.numValues());
            StringUtils.appendNewline(out);
        }

        public int subtreeDepth() {
            return 0;
        }

        public double calculatePromise() {
            double totalSeen = this.observedClassDistribution.sumOfValues();
            return totalSeen > 0.0 ? totalSeen - this.observedClassDistribution.getValue(this.observedClassDistribution.maxIndex()) : 0.0;
        }

        @Override
        public void getDescription(StringBuilder sb, int indent) {
            this.describeSubtree(null, sb, indent);
        }
    }

    public static class FoundNode {
        public Node node;
        public SplitNode parent;
        public int parentBranch;

        public FoundNode(Node node, SplitNode parent, int parentBranch) {
            this.node = node;
            this.parent = parent;
            this.parentBranch = parentBranch;
        }
    }
}

