% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/osrmfunctions.R
\name{decode_gl}
\alias{decode_gl}
\title{Decode Google polyline compressed string}
\usage{
decode_gl(polyline, precision = 6, forceline = TRUE)
}
\arguments{
\item{polyline}{A character string or vector of character strings containing
the encoded polyline to be decoded.}

\item{precision}{An integer indicating the number of decimals in the
initial encoded coordinates. Default is 6 (for OSRM default).}

\item{forceline}{Boolean value indicating if the returned coordinates should
be a line (i.e., minimum two points) Default is TRUE.}
}
\description{
Decode Google polyline compressed string
}
\section{Details}{

An implementation of the Google Maps Encoded Polyline Algorithm for decoding
strings. Returns a dataframe if polyline is of length 1 and a list of
dataframes otherwise.

See the more recent googlePolylines package, which is faster:
https://github.com/SymbolixAU/googlePolylines
}

\examples{
\dontrun{
decode_gl("_p~iF~ps|U_ulLnnqC_mqNvxq`@", precision = 5)
}
}
\seealso{
Other geo: \code{\link{bbox_scale}},
  \code{\link{buff_geo}}, \code{\link{crs_select_aeq}},
  \code{\link{gclip}}, \code{\link{geo_bb_matrix}},
  \code{\link{geo_bb}}, \code{\link{mapshape_available}},
  \code{\link{mapshape}}, \code{\link{quadrant}},
  \code{\link{reproject}}
}
\concept{geo}
