% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_mp_pic.R
\name{get_mp_pic}
\alias{get_mp_pic}
\title{Retrieve picture of specific MPs}
\usage{
get_mp_pic(mpid = NA, size = "middels", 
           destfile = NA, show_plot = FALSE, 
           good_manners = 0)
}
\arguments{
\item{mpid}{Character string indicating the id of the MP to retrieve.}

\item{size}{Character string size of the picture. Accepts values "lite" (small), "middels" (medium -- default), and "stort" (big).}

\item{destfile}{Character string specifying where to save the picture}

\item{show_plot}{Logical. FALSE (default) if no plot should be produced and TRUE if plot should be produced. Requires the "imager" package.}

\item{good_manners}{Integer. Seconds delay between calls when making multiple calls to the same function}
}
\value{
Picture of the requested MP in the preferred size.
}
\description{
A function for retrieving Norwegian MP pictures by id.
}
\examples{
\dontrun{
# Request one MP by id
get_mp_pic(mpid = "AAMH", destfile = "~/Pictures/AAMH.jpeg", show_plot = TRUE, size = "stort")

# With good manners for multiple calls
lapply(c("AAMH", "CIH", "TKF"), function(x){
  get_mp_pic(mpid = x, destfile = paste0("~/Pictures/", x), 
  show_plot = TRUE, size = "stort", good_manners = 2)
  })
}

}
\seealso{
\link{get_mp} \link{get_parlperiod_mps} \link{get_mp_bio}
}
