% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rd-co2emissions.R
\docType{data}
\name{co2emissions}
\alias{co2emissions}
\title{Carbon Dioxide Emissions Data}
\format{
A data frame with 3,099 observations on the following 2 variables.
\describe{
\item{\code{year}}{the year (negative values = BCE)}
\item{\code{value}}{estimated carbon dioxide emissions (in ppm)}
}
}
\usage{
co2emissions
}
\description{
This is a sample data set, cobbled from various sources, about
 carbon dioxide emissions in the history of the planet from 800,000 BCE to
 the most recently concluded calendar year. I use this for a data visualization
 example for a lecture on climate change and international politics.
 Data communicate yearly averages/estimates.
}
\details{
The data come from many sources. Before 0 CE, the data come from 10 sources
described here by the EPA
(\url{https://www.epa.gov/climate-indicators/climate-change-indicators-atmospheric-concentrations-greenhouse-gases}).
Observations from 0 CE to 2014 come from Meinshausen et al. (2017)
(\url{https://gmd.copernicus.org/articles/10/2057/2017/}). Observations from 2015 forward come
from NASA (\url{https://climate.nasa.gov/vital-signs/carbon-dioxide/}).
}
\references{
EPICA Dome C and Vostok Station, Antarctica: approximately 796,562 BCE to 1813 CE
Lüthi, D., M. Le Floch, B. Bereiter, T. Blunier, J.-M. Barnola, U. Siegenthaler, D. Raynaud,
J. Jouzel, H. Fischer, K. Kawamura, and T.F. Stocker. 2008. High-resolution carbon dioxide
concentration record 650,000–800,000 years before present. Nature 453:379–382.
\url{https://www.ncdc.noaa.gov/paleo-search/}.

Law Dome, Antarctica, 75-year smoothed: approximately 1010 CE to 1975 CE
Etheridge, D.M., L.P. Steele, R.L. Langenfelds, R.J. Francey, J.-M. Barnola,
and V.I. Morgan. 1998. Historical CO2 records from the Law Dome DE08, DE08-2,
and DSS ice cores. In: Trends: A compendium of data on global change.
Oak Ridge, TN: U.S. Department of Energy. \url{https://cdiac.ess-dive.lbl.gov/trends/co2/lawdome.html}.

Siple Station, Antarctica: approximately 1744 CE to 1953 CE Neftel, A.,
H. Friedli, E. Moor, H. Lötscher, H. Oeschger, U. Siegenthaler, and B. Stauffer.
1994. Historical carbon dioxide record from the Siple Station ice core.
In: Trends: A compendium of data on global change.
Oak Ridge, TN: U.S. Department of Energy.
\url{https://cdiac.ess-dive.lbl.gov/trends/co2/siple.html}

Mauna Loa, Hawaii: 1959 CE to 2015 CE NOAA
(National Oceanic and Atmospheric Administration). 2016.
Annual mean carbon dioxide concentrations for Mauna Loa, Hawaii.

Barrow, Alaska: 1974 CE to 2014 CE Cape Matatula, American Samoa:
1976 CE to 2014 CE South Pole, Antarctica: 1976 CE to 2014 CE NOAA
(National Oceanic and Atmospheric Administration). 2016.
Monthly mean carbon dioxide concentrations for Barrow, Alaska; Cape Matatula,
American Samoa; and the South Pole.

Cape Grim, Australia: 1992 CE to 2006 CE Shetland Islands, Scotland:
1993 CE to 2002 CE Steele, L.P., P.B. Krummel, and R.L. Langenfelds. 2007.
Atmospheric CO2 concentrations (ppmv) derived from flask air samples collected at
Cape Grim, Australia, and Shetland Islands, Scotland. Commonwealth Scientific
and Industrial Research Organisation.
\url{https://cdiac.ess-dive.lbl.gov/trends/co2/sio-keel-flask/sio-keel-flaskmlo_c.html}.

Lampedusa Island, Italy: 1993 CE to 2000 CE Chamard, P., L. Ciattaglia, A. di Sarra,
and F. Monteleone. 2001. Atmospheric carbon dioxide record from flask measurements
at Lampedusa Island. In: Trends: A compendium of data on global change.
Oak Ridge, TN: U.S. Department of Energy.
\url{https://cdiac.ess-dive.lbl.gov/trends/co2/lampis.html}.

Meinshausen, M., Vogel, E., Nauels, A., Lorbacher, K., Meinshausen,
N., Etheridge, D. M., Fraser, P. J., Montzka, S. A., Rayner, P. J., Trudinger,
C. M., Krummel, P. B., Beyerle, U., Canadell, J. G., Daniel, J. S., Enting,
I. G., Law, R. M., Lunder, C. R., O'Doherty, S., Prinn, R. G., Reimann, S., Rubino,
M., Velders, G. J. M., Vollmer, M. K., Wang, R. H. J., and Weiss, R.:
Historical greenhouse gas concentrations for climate modelling (CMIP6),
Geosci. Model Dev., 10, 2057-2116, 2017.
\url{https://gmd.copernicus.org/articles/10/2057/2017/}.
}
\keyword{datasets}
