% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/visualisation.R
\name{plot_pop_trend}
\alias{plot_pop_trend}
\title{Plot population trend}
\usage{
plot_pop_trend(x, stages = NULL, emp = FALSE, return_data = FALSE, ...)
}
\arguments{
\item{x}{a simulation_results object}

\item{stages}{life-stages to plot - by default all life-stages will be shown. 
Set to zero for totals (i.e. sums of all life-stages).}

\item{emp}{(TRUE/FALSE) add a dashed line indicating the expected minimum
population of the simulation (for multiple replicates only)}

\item{return_data}{(TRUE/FALSE) should the data used to create the plots be returned?}

\item{...}{further arguments passed to/from other methods}
}
\description{
Plot linear graphs to illustrate population changes through time.
}
\examples{

\dontrun{
ls <- landscape(population = egk_pop, suitability = egk_hab, carrying_capacity = egk_k)

pd <- population_dynamics(change = growth(egk_mat),
                          dispersal = kernel_dispersal(max_distance = 2000,
                                        dispersal_kernel = exponential_dispersal_kernel(
                                          distance_decay = 1000)),
                          density_dependence = ceiling_density())

sim <- simulation(landscape = ls,
                  population_dynamics = pd,
                  habitat_dynamics = NULL,
                  timesteps = 20)

# Plot the population trajectories by life-stage
plot_pop_trend(sim)

# Plot the total population trajectory
plot_pop_trend(sim, stages = 0) 
}
}
